/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.liquibase;

import io.zonky.test.db.liquibase.LiquibaseDescriptor;
import io.zonky.test.db.preparer.DatabasePreparer;
import io.zonky.test.db.shaded.com.google.common.base.MoreObjects;
import io.zonky.test.db.shaded.com.google.common.base.Stopwatch;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Objects;
import javax.sql.DataSource;
import liquibase.exception.ChangeLogParseException;
import liquibase.exception.LiquibaseException;
import liquibase.integration.spring.SpringLiquibase;
import liquibase.resource.ResourceAccessor;
import liquibase.util.StreamUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiquibaseDatabasePreparer
implements DatabasePreparer {
    private static final Logger logger = LoggerFactory.getLogger(LiquibaseDatabasePreparer.class);
    private final LiquibaseDescriptor descriptor;
    private volatile Long estimatedDuration;

    public LiquibaseDatabasePreparer(LiquibaseDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    @Override
    public long estimatedDuration() {
        if (this.estimatedDuration == null) {
            Stopwatch stopwatch = Stopwatch.createStarted();
            SpringLiquibase springLiquibase = new SpringLiquibase();
            springLiquibase.setResourceLoader(this.descriptor.getResourceLoader());
            SpringLiquibase springLiquibase2 = springLiquibase;
            springLiquibase2.getClass();
            SpringLiquibase.SpringResourceOpener resourceAccessor = new SpringLiquibase.SpringResourceOpener(springLiquibase2, this.descriptor.getChangeLog());
            long linesCount = this.resolveChangeLogLines(this.descriptor.getChangeLog(), (ResourceAccessor)resourceAccessor);
            this.estimatedDuration = 100L + linesCount * 2L;
            logger.trace("Resolved {} changelog lines in {}", (Object)linesCount, (Object)stopwatch);
        }
        return this.estimatedDuration;
    }

    @Override
    public void prepare(DataSource dataSource) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        SpringLiquibase liquibase = new SpringLiquibase();
        this.descriptor.applyTo(liquibase);
        liquibase.setDataSource(dataSource);
        try {
            liquibase.afterPropertiesSet();
        }
        catch (LiquibaseException e) {
            throw new IllegalStateException("Unexpected error when running Liquibase", e);
        }
        logger.trace("Database has been successfully prepared in {}", (Object)stopwatch);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LiquibaseDatabasePreparer that = (LiquibaseDatabasePreparer)o;
        return Objects.equals(this.descriptor, that.descriptor);
    }

    public int hashCode() {
        return Objects.hash(this.descriptor);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("changeLog", this.descriptor.getChangeLog()).add("estimatedDuration", this.estimatedDuration()).toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected long resolveChangeLogLines(String path, ResourceAccessor resourceAccessor) {
        try {
            String changeLogPath = path.replace('\\', '/');
            InputStream changeLogStream = StreamUtil.singleInputStream((String)changeLogPath, (ResourceAccessor)resourceAccessor);
            if (changeLogStream == null) {
                throw new ChangeLogParseException(changeLogPath + " does not exist");
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(changeLogStream));){
                long l = reader.lines().count();
                return l;
            }
        }
        catch (Exception e) {
            logger.warn("Unexpected error when resolving liquibase changelog", (Throwable)e);
            return 10000L;
        }
    }
}

