/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.reporter;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import zipkin2.reporter.BytesMessageSender;
import zipkin2.reporter.Call;
import zipkin2.reporter.ClosedSenderException;
import zipkin2.reporter.Encoding;
import zipkin2.reporter.HttpEndpointSupplier;

public abstract class BaseHttpSender<U, B>
extends BytesMessageSender.Base {
    final Logger logger;
    final HttpEndpointSupplier endpointSupplier;
    final U endpoint;
    final AtomicBoolean closeCalled = new AtomicBoolean();

    protected abstract U newEndpoint(String var1);

    protected abstract B newBody(List<byte[]> var1) throws IOException;

    protected abstract void postSpans(U var1, B var2) throws IOException;

    protected void doClose() {
    }

    protected BaseHttpSender(Encoding encoding, HttpEndpointSupplier.Factory endpointSupplierFactory, String endpoint) {
        this(Logger.getLogger(BaseHttpSender.class.getName()), encoding, endpointSupplierFactory, endpoint);
    }

    BaseHttpSender(Logger logger, Encoding encoding, HttpEndpointSupplier.Factory endpointSupplierFactory, String endpoint) {
        super(encoding);
        this.logger = logger;
        if (endpointSupplierFactory == null) {
            throw new NullPointerException("endpointSupplierFactory == null");
        }
        if (endpoint == null) {
            throw new NullPointerException("endpoint == null");
        }
        HttpEndpointSupplier endpointSupplier = endpointSupplierFactory.create(endpoint);
        if (endpointSupplier == null) {
            throw new NullPointerException("endpointSupplierFactory.create() returned null");
        }
        if (endpointSupplier instanceof HttpEndpointSupplier.Constant) {
            this.endpoint = this.nextEndpoint(endpointSupplier);
            this.closeQuietly(endpointSupplier);
            this.endpointSupplier = null;
        } else {
            this.endpoint = null;
            this.endpointSupplier = endpointSupplier;
        }
    }

    final U nextEndpoint(HttpEndpointSupplier endpointSupplier) {
        String endpoint = endpointSupplier.get();
        if (endpoint == null) {
            throw new NullPointerException("endpointSupplier.get() returned null");
        }
        return this.newEndpoint(endpoint);
    }

    @Override
    public int messageMaxBytes() {
        return 524288;
    }

    @Override
    public final void send(List<byte[]> encodedSpans) throws IOException {
        B body;
        if (this.closeCalled.get()) {
            throw new ClosedSenderException();
        }
        U endpoint = this.endpoint;
        if (endpoint == null) {
            endpoint = this.nextEndpoint(this.endpointSupplier);
        }
        if ((body = this.newBody(encodedSpans)) == null) {
            throw new NullPointerException("newBody(encodedSpans) returned null");
        }
        this.postSpans(endpoint, body);
    }

    @Override
    public final void close() {
        if (!this.closeCalled.compareAndSet(false, true)) {
            return;
        }
        this.closeQuietly(this.endpointSupplier);
        this.doClose();
    }

    final void closeQuietly(HttpEndpointSupplier endpointSupplier) {
        if (endpointSupplier == null) {
            return;
        }
        try {
            endpointSupplier.close();
        }
        catch (Throwable t) {
            Call.propagateIfFatal(t);
            this.logger.fine("ignoring error closing endpoint supplier: " + t.getMessage());
        }
    }

    public String toString() {
        String name = this.getClass().getSimpleName();
        if (this.endpoint != null) {
            return name + "{" + this.endpoint + "}";
        }
        return name + "{" + this.endpointSupplier + "}";
    }
}

