/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.reporter;

import java.util.ArrayList;
import java.util.Iterator;
import zipkin2.codec.Encoding;
import zipkin2.reporter.Sender;
import zipkin2.reporter.SpanWithSizeConsumer;

abstract class BufferNextMessage<S>
implements SpanWithSizeConsumer<S> {
    final Sender sender;
    final int maxBytes;
    final long timeoutNanos;
    final ArrayList<S> spans = new ArrayList();
    final ArrayList<Integer> sizes = new ArrayList();
    long deadlineNanoTime;
    int messageSizeInBytes;
    boolean bufferFull;

    static <S> BufferNextMessage<S> create(Sender sender, int maxBytes, long timeoutNanos) {
        if (sender.encoding() != Encoding.JSON) {
            throw new UnsupportedOperationException("sender.encoding() != Encoding.JSON");
        }
        return new BufferNextJsonMessage(sender, maxBytes, timeoutNanos);
    }

    BufferNextMessage(Sender sender, int maxBytes, long timeoutNanos) {
        this.sender = sender;
        this.maxBytes = maxBytes;
        this.timeoutNanos = timeoutNanos;
    }

    abstract int messageSizeInBytes(int var1);

    abstract void resetMessageSizeInBytes();

    @Override
    public boolean offer(S next, int nextSizeInBytes) {
        int includingNextVsMaxBytes;
        int y;
        int x = this.messageSizeInBytes(nextSizeInBytes);
        int n = x < (y = this.maxBytes) ? -1 : (includingNextVsMaxBytes = x == y ? 0 : 1);
        if (includingNextVsMaxBytes > 0) {
            return false;
        }
        this.addSpanToBuffer(next, nextSizeInBytes);
        this.messageSizeInBytes = x;
        if (includingNextVsMaxBytes == 0) {
            this.bufferFull = true;
        }
        return true;
    }

    void addSpanToBuffer(S next, int nextSizeInBytes) {
        this.spans.add(next);
        this.sizes.add(nextSizeInBytes);
    }

    long remainingNanos() {
        if (this.spans.isEmpty()) {
            this.deadlineNanoTime = System.nanoTime() + this.timeoutNanos;
        }
        return Math.max(this.deadlineNanoTime - System.nanoTime(), 0L);
    }

    boolean isReady() {
        return this.bufferFull || this.remainingNanos() <= 0L;
    }

    void drain(SpanWithSizeConsumer<S> consumer) {
        Iterator<S> spanIterator = this.spans.iterator();
        Iterator<Integer> sizeIterator = this.sizes.iterator();
        while (spanIterator.hasNext()) {
            if (!consumer.offer(spanIterator.next(), sizeIterator.next())) continue;
            this.bufferFull = false;
            spanIterator.remove();
            sizeIterator.remove();
        }
        this.resetMessageSizeInBytes();
        this.deadlineNanoTime = 0L;
    }

    int count() {
        return this.spans.size();
    }

    int sizeInBytes() {
        return this.messageSizeInBytes;
    }

    static final class BufferNextJsonMessage<S>
    extends BufferNextMessage<S> {
        boolean hasAtLeastOneSpan;

        BufferNextJsonMessage(Sender sender, int maxBytes, long timeoutNanos) {
            super(sender, maxBytes, timeoutNanos);
            this.messageSizeInBytes = 2;
            this.hasAtLeastOneSpan = false;
        }

        @Override
        int messageSizeInBytes(int nextSizeInBytes) {
            return this.messageSizeInBytes + nextSizeInBytes + (this.hasAtLeastOneSpan ? 1 : 0);
        }

        @Override
        void resetMessageSizeInBytes() {
            int length = this.sizes.size();
            this.messageSizeInBytes = 2 + length - 1;
            this.hasAtLeastOneSpan = length > 2;
            for (int i = 0; i < length; ++i) {
                this.messageSizeInBytes += ((Integer)this.sizes.get(i)).intValue();
            }
        }

        @Override
        void addSpanToBuffer(S next, int nextSizeInBytes) {
            super.addSpanToBuffer(next, nextSizeInBytes);
            this.hasAtLeastOneSpan = true;
        }

        @Override
        void drain(SpanWithSizeConsumer<S> consumer) {
            super.drain(consumer);
            this.messageSizeInBytes = 2;
            this.hasAtLeastOneSpan = false;
        }
    }
}

