/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.reporter.brave;

import brave.Tag;
import brave.Tags;
import brave.handler.MutableSpan;
import zipkin2.reporter.BytesEncoder;
import zipkin2.reporter.Encoding;
import zipkin2.reporter.brave.JsonV2Encoder;
import zipkin2.reporter.brave.ZipkinProto3Encoder;

public enum MutableSpanBytesEncoder implements BytesEncoder<MutableSpan>
{
    JSON_V2{

        public Encoding encoding() {
            return Encoding.JSON;
        }

        public int sizeInBytes(MutableSpan input) {
            return JsonV2Encoder.INSTANCE.sizeInBytes((Object)input);
        }

        public byte[] encode(MutableSpan input) {
            return JsonV2Encoder.INSTANCE.encode((Object)input);
        }
    }
    ,
    PROTO3{

        public Encoding encoding() {
            return Encoding.PROTO3;
        }

        public int sizeInBytes(MutableSpan input) {
            return ZipkinProto3Encoder.INSTANCE.sizeInBytes((Object)input);
        }

        public byte[] encode(MutableSpan input) {
            return ZipkinProto3Encoder.INSTANCE.encode((Object)input);
        }
    };


    public static BytesEncoder<MutableSpan> forEncoding(Encoding encoding) {
        if (encoding == null) {
            throw new NullPointerException("encoding == null");
        }
        switch (encoding) {
            case JSON: {
                return JSON_V2;
            }
            case PROTO3: {
                return PROTO3;
            }
            case THRIFT: {
                throw new UnsupportedOperationException("THRIFT is not yet a built-in encoder");
            }
        }
        throw new UnsupportedOperationException("BUG: " + encoding.name());
    }

    public static BytesEncoder<MutableSpan> create(Encoding encoding, Tag<Throwable> errorTag) {
        if (encoding == null) {
            throw new NullPointerException("encoding == null");
        }
        if (errorTag == null) {
            throw new NullPointerException("errorTag == null");
        }
        if (errorTag == Tags.ERROR) {
            return MutableSpanBytesEncoder.forEncoding(encoding);
        }
        switch (encoding) {
            case JSON: {
                return new JsonV2Encoder(errorTag);
            }
            case PROTO3: {
                return new ZipkinProto3Encoder(errorTag);
            }
            case THRIFT: {
                throw new UnsupportedOperationException("THRIFT is not yet a built-in encoder");
            }
        }
        throw new UnsupportedOperationException("BUG: " + encoding.name());
    }
}

