/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.reporter.brave.internal;

import brave.Span;
import brave.Tag;
import brave.handler.MutableSpan;
import zipkin2.reporter.brave.internal.Proto3Fields;
import zipkin2.reporter.brave.internal.WriteBuffer;
import zipkin2.reporter.internal.Nullable;

final class ZipkinProto3Fields {
    ZipkinProto3Fields() {
    }

    static class SpanField
    extends Proto3Fields.LengthDelimitedField<MutableSpan> {
        static final int TRACE_ID_KEY = 10;
        static final int PARENT_ID_KEY = 18;
        static final int ID_KEY = 26;
        static final int KIND_KEY = 32;
        static final int NAME_KEY = 42;
        static final int TIMESTAMP_KEY = 49;
        static final int DURATION_KEY = 56;
        static final int LOCAL_ENDPOINT_KEY = 66;
        static final int REMOTE_ENDPOINT_KEY = 74;
        static final int ANNOTATION_KEY = 82;
        static final int TAG_KEY = 90;
        static final int DEBUG_KEY = 96;
        static final int SHARED_KEY = 104;
        static final Proto3Fields.HexField TRACE_ID = new Proto3Fields.HexField(10);
        static final Proto3Fields.HexField PARENT_ID = new Proto3Fields.HexField(18);
        static final Proto3Fields.HexField ID = new Proto3Fields.HexField(26);
        static final Proto3Fields.VarintField KIND = new Proto3Fields.VarintField(32);
        static final Proto3Fields.Utf8Field NAME = new Proto3Fields.Utf8Field(42);
        static final Proto3Fields.Fixed64Field TIMESTAMP = new Proto3Fields.Fixed64Field(49);
        static final Proto3Fields.VarintField DURATION = new Proto3Fields.VarintField(56);
        static final EndpointField LOCAL_ENDPOINT = new EndpointField(66);
        static final EndpointField REMOTE_ENDPOINT = new EndpointField(74);
        static final AnnotationField ANNOTATION = new AnnotationField(82);
        static final TagField TAG = new TagField(90);
        static final Proto3Fields.BooleanField DEBUG = new Proto3Fields.BooleanField(96);
        static final Proto3Fields.BooleanField SHARED = new Proto3Fields.BooleanField(104);
        final Tag<Throwable> errorTag;

        SpanField(Tag<Throwable> errorTag) {
            super(10);
            if (errorTag == null) {
                throw new NullPointerException("errorTag == null");
            }
            this.errorTag = errorTag;
        }

        @Override
        int sizeOfValue(MutableSpan span) {
            boolean writeError;
            int sizeInBytes = TRACE_ID.sizeInBytes(span.traceId());
            sizeInBytes += PARENT_ID.sizeInBytes(span.parentId());
            sizeInBytes += ID.sizeInBytes(span.id());
            sizeInBytes += KIND.sizeInBytes(span.kind() != null ? 1 : 0);
            sizeInBytes += NAME.sizeInBytes(span.name());
            if (span.startTimestamp() != 0L) {
                sizeInBytes += TIMESTAMP.sizeInBytes(span.startTimestamp());
                if (span.finishTimestamp() != 0L) {
                    sizeInBytes += DURATION.sizeInBytes(span.finishTimestamp() - span.startTimestamp());
                }
            }
            sizeInBytes += LOCAL_ENDPOINT.sizeInBytes(span.localServiceName(), span.localIp(), span.localPort());
            sizeInBytes += REMOTE_ENDPOINT.sizeInBytes(span.remoteServiceName(), span.remoteIp(), span.remotePort());
            int annotationLength = span.annotationCount();
            for (int i = 0; i < annotationLength; ++i) {
                sizeInBytes += ANNOTATION.sizeInBytes(span.annotationTimestampAt(i), span.annotationValueAt(i));
            }
            int tagCount = span.tagCount();
            String errorValue = this.errorTag.value((Object)span.error(), null);
            String errorTagName = errorValue != null ? this.errorTag.key() : null;
            boolean bl = writeError = errorTagName != null;
            if (tagCount > 0 || writeError) {
                for (int i = 0; i < tagCount; ++i) {
                    String key = span.tagKeyAt(i);
                    if (writeError && key.equals(errorTagName)) {
                        writeError = false;
                    }
                    sizeInBytes += TAG.sizeInBytes(key, span.tagValueAt(i));
                }
                if (writeError) {
                    sizeInBytes += TAG.sizeInBytes(errorTagName, errorValue);
                }
            }
            sizeInBytes += DEBUG.sizeInBytes(Boolean.TRUE.equals(span.debug()));
            return sizeInBytes += SHARED.sizeInBytes(Boolean.TRUE.equals(span.shared()));
        }

        @Override
        void writeValue(WriteBuffer b, MutableSpan span) {
            boolean writeError;
            TRACE_ID.write(b, span.traceId());
            PARENT_ID.write(b, span.parentId());
            ID.write(b, span.id());
            KIND.write(b, this.toByte(span.kind()));
            NAME.write(b, span.name());
            if (span.startTimestamp() != 0L) {
                TIMESTAMP.write(b, span.startTimestamp());
                if (span.finishTimestamp() != 0L) {
                    DURATION.write(b, span.finishTimestamp() - span.startTimestamp());
                }
            }
            LOCAL_ENDPOINT.write(b, span.localServiceName(), span.localIp(), span.localPort());
            REMOTE_ENDPOINT.write(b, span.remoteServiceName(), span.remoteIp(), span.remotePort());
            int annotationLength = span.annotationCount();
            for (int i = 0; i < annotationLength; ++i) {
                ANNOTATION.write(b, span.annotationTimestampAt(i), span.annotationValueAt(i));
            }
            int tagCount = span.tagCount();
            String errorValue = this.errorTag.value((Object)span.error(), null);
            String errorTagName = errorValue != null ? this.errorTag.key() : null;
            boolean bl = writeError = errorTagName != null;
            if (tagCount > 0 || writeError) {
                for (int i = 0; i < tagCount; ++i) {
                    String key = span.tagKeyAt(i);
                    if (writeError && key.equals(errorTagName)) {
                        writeError = false;
                    }
                    TAG.write(b, key, span.tagValueAt(i));
                }
                if (writeError) {
                    TAG.write(b, errorTagName, errorValue);
                }
            }
            DEBUG.write(b, Boolean.TRUE.equals(span.debug()));
            SHARED.write(b, Boolean.TRUE.equals(span.shared()));
        }

        int toByte(Span.Kind kind) {
            return kind != null ? kind.ordinal() + 1 : 0;
        }
    }

    static final class TagField
    extends Proto3Fields.Field {
        static final int KEY_KEY = 10;
        static final int VALUE_KEY = 18;
        static final Proto3Fields.Utf8Field KEY = new Proto3Fields.Utf8Field(10);
        static final Proto3Fields.Utf8Field VALUE = new Proto3Fields.Utf8Field(18);

        TagField(int key) {
            super(key);
            assert (this.wireType == 2);
        }

        int sizeInBytes(String key, String value) {
            int sizeInBytes = TagField.sizeOfValue(key, value);
            return Proto3Fields.sizeOfLengthDelimitedField(sizeInBytes);
        }

        static int sizeOfValue(String key, String value) {
            return KEY.sizeInBytes(key) + VALUE.sizeInBytes(value);
        }

        void write(WriteBuffer b, String key, String value) {
            if (value == null) {
                return;
            }
            int sizeOfValue = TagField.sizeOfValue(key, value);
            b.writeByte(this.key);
            b.writeVarint(sizeOfValue);
            KEY.write(b, key);
            VALUE.write(b, value);
        }
    }

    static class AnnotationField
    extends Proto3Fields.Field {
        static final int TIMESTAMP_KEY = 9;
        static final int VALUE_KEY = 18;
        static final Proto3Fields.Fixed64Field TIMESTAMP = new Proto3Fields.Fixed64Field(9);
        static final Proto3Fields.Utf8Field VALUE = new Proto3Fields.Utf8Field(18);

        AnnotationField(int key) {
            super(key);
            assert (this.wireType == 2);
        }

        int sizeInBytes(long timestamp, String value) {
            int sizeOfValue = AnnotationField.sizeOfValue(timestamp, value);
            return Proto3Fields.sizeOfLengthDelimitedField(sizeOfValue);
        }

        static int sizeOfValue(long timestamp, String value) {
            return TIMESTAMP.sizeInBytes(timestamp) + VALUE.sizeInBytes(value);
        }

        final void write(WriteBuffer b, long timestamp, String value) {
            int sizeOfValue = AnnotationField.sizeOfValue(timestamp, value);
            b.writeByte(this.key);
            b.writeVarint(sizeOfValue);
            TIMESTAMP.write(b, timestamp);
            VALUE.write(b, value);
        }
    }

    static class EndpointField
    extends Proto3Fields.Field {
        static final int SERVICE_NAME_KEY = 10;
        static final int IPV4_KEY = 18;
        static final int IPV6_KEY = 26;
        static final int PORT_KEY = 32;
        static final Proto3Fields.Utf8Field SERVICE_NAME = new Proto3Fields.Utf8Field(10);
        static final Proto3Fields.IPv4Field IPV4 = new Proto3Fields.IPv4Field(18);
        static final Proto3Fields.IPv6Field IPV6 = new Proto3Fields.IPv6Field(26);
        static final Proto3Fields.VarintField PORT = new Proto3Fields.VarintField(32);

        EndpointField(int key) {
            super(key);
            assert (this.wireType == 2);
        }

        int sizeInBytes(@Nullable String serviceName, @Nullable String ip, int port) {
            int sizeOfValue = EndpointField.sizeOfValue(serviceName, ip, port);
            return sizeOfValue > 0 ? Proto3Fields.sizeOfLengthDelimitedField(sizeOfValue) : 0;
        }

        static int sizeOfValue(@Nullable String serviceName, @Nullable String ip, int port) {
            int sizeInBytes = 0;
            sizeInBytes += SERVICE_NAME.sizeInBytes(serviceName);
            sizeInBytes = ip != null && ip.indexOf(46) != -1 ? (sizeInBytes += IPV4.sizeInBytes(ip)) : (sizeInBytes += IPV6.sizeInBytes(ip));
            return sizeInBytes += PORT.sizeInBytes(port);
        }

        void write(WriteBuffer b, @Nullable String serviceName, @Nullable String ip, int port) {
            int sizeOfValue = EndpointField.sizeOfValue(serviceName, ip, port);
            if (sizeOfValue == 0) {
                return;
            }
            b.writeByte(this.key);
            b.writeVarint(sizeOfValue);
            SERVICE_NAME.write(b, serviceName);
            if (ip != null && ip.indexOf(46) != -1) {
                IPV4.write(b, ip);
            } else {
                IPV6.write(b, ip);
            }
            PORT.write(b, port);
        }
    }
}

