/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.reporter.brave;

import brave.Tag;
import brave.handler.MutableSpan;
import brave.handler.SpanHandler;
import brave.propagation.TraceContext;
import java.io.Closeable;
import java.io.Flushable;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import zipkin2.reporter.BytesEncoder;
import zipkin2.reporter.Encoding;
import zipkin2.reporter.Reporter;
import zipkin2.reporter.ReporterMetrics;
import zipkin2.reporter.Sender;
import zipkin2.reporter.brave.JsonV2Encoder;
import zipkin2.reporter.brave.ZipkinSpanHandler;
import zipkin2.reporter.internal.AsyncReporter;

public final class AsyncZipkinSpanHandler
extends SpanHandler
implements Closeable,
Flushable {
    final Reporter<MutableSpan> spanReporter;
    final Encoding encoding;
    final Tag<Throwable> errorTag;
    final boolean alwaysReportSpans;

    public static AsyncZipkinSpanHandler create(Sender sender) {
        return AsyncZipkinSpanHandler.newBuilder(sender).build();
    }

    public static Builder newBuilder(Sender sender) {
        if (sender == null) {
            throw new NullPointerException("sender == null");
        }
        return new Builder(sender);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    AsyncZipkinSpanHandler(AsyncReporter<MutableSpan> spanReporter, Builder builder) {
        this.spanReporter = spanReporter;
        this.encoding = builder.encoding;
        this.errorTag = builder.errorTag;
        this.alwaysReportSpans = builder.alwaysReportSpans;
    }

    @Override
    public void flush() {
        ((AsyncReporter)this.spanReporter).flush();
    }

    @Override
    public void close() {
        ((AsyncReporter)this.spanReporter).close();
    }

    public boolean end(TraceContext context, MutableSpan span, SpanHandler.Cause cause) {
        if (!this.alwaysReportSpans && !Boolean.TRUE.equals(context.sampled())) {
            return true;
        }
        this.spanReporter.report((Object)span);
        return true;
    }

    public String toString() {
        return this.spanReporter.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AsyncZipkinSpanHandler)) {
            return false;
        }
        return this.spanReporter.equals(((AsyncZipkinSpanHandler)o).spanReporter);
    }

    public int hashCode() {
        return this.spanReporter.hashCode();
    }

    public static final class Builder
    extends ZipkinSpanHandler.Builder {
        final AsyncReporter.Builder delegate;
        final Encoding encoding;

        Builder(AsyncZipkinSpanHandler handler) {
            this.delegate = ((AsyncReporter)handler.spanReporter).toBuilder();
            this.encoding = handler.encoding;
            this.alwaysReportSpans = handler.alwaysReportSpans;
            this.errorTag = handler.errorTag;
        }

        Builder(Sender sender) {
            this.delegate = AsyncReporter.newBuilder((Sender)sender);
            this.encoding = sender.encoding();
        }

        public Builder threadFactory(ThreadFactory threadFactory) {
            this.delegate.threadFactory(threadFactory);
            return this;
        }

        public Builder metrics(ReporterMetrics metrics) {
            this.delegate.metrics(metrics);
            return this;
        }

        public Builder messageMaxBytes(int messageMaxBytes) {
            this.delegate.messageMaxBytes(messageMaxBytes);
            return this;
        }

        public Builder messageTimeout(long timeout, TimeUnit unit) {
            this.delegate.messageTimeout(timeout, unit);
            return this;
        }

        public Builder closeTimeout(long timeout, TimeUnit unit) {
            this.delegate.closeTimeout(timeout, unit);
            return this;
        }

        public Builder queuedMaxSpans(int queuedMaxSpans) {
            this.delegate.queuedMaxSpans(queuedMaxSpans);
            return this;
        }

        public Builder queuedMaxBytes(int queuedMaxBytes) {
            this.delegate.queuedMaxBytes(queuedMaxBytes);
            return this;
        }

        @Override
        public Builder errorTag(Tag<Throwable> errorTag) {
            return (Builder)super.errorTag(errorTag);
        }

        @Override
        public Builder alwaysReportSpans(boolean alwaysReportSpans) {
            return (Builder)super.alwaysReportSpans(alwaysReportSpans);
        }

        @Override
        public AsyncZipkinSpanHandler build() {
            switch (this.encoding) {
                case JSON: {
                    return this.build(new JsonV2Encoder((Tag<Throwable>)this.errorTag));
                }
            }
            throw new UnsupportedOperationException(this.encoding.name());
        }

        public AsyncZipkinSpanHandler build(BytesEncoder<MutableSpan> encoder) {
            if (encoder == null) {
                throw new NullPointerException("encoder == null");
            }
            return new AsyncZipkinSpanHandler((AsyncReporter<MutableSpan>)this.delegate.build(encoder), this);
        }
    }
}

