/*
 * Decompiled with CFR 0.152.
 */
package brave.test.util;

import brave.internal.Nullable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AtomicIntegerAssert;
import org.assertj.core.api.ObjectAssert;

public final class AssertableCallback<V>
extends CountDownLatch
implements BiConsumer<V, Throwable> {
    static final Object NULL_SENTINEL = new Object(){

        public String toString() {
            return "null";
        }
    };
    final AtomicInteger onSuccessCount = new AtomicInteger();
    final AtomicInteger onErrorCount = new AtomicInteger();
    Runnable listener = () -> {};
    Object result;
    Object error;

    public AssertableCallback() {
        super(1);
    }

    public AssertableCallback<V> setListener(Runnable listener) {
        if (listener == null) {
            throw new NullPointerException("listener == null");
        }
        this.listener = listener;
        return this;
    }

    public void onSuccess(@Nullable V value) {
        this.onSuccessCount.incrementAndGet();
        this.result = value != null ? value : NULL_SENTINEL;
        this.listener.run();
        this.countDown();
    }

    public void onError(Throwable throwable) {
        this.onErrorCount.incrementAndGet();
        this.error = throwable != null ? throwable : NULL_SENTINEL;
        this.listener.run();
        this.countDown();
    }

    @Nullable
    public V join() {
        this.awaitUninterruptably();
        if (this.onSuccessCount.get() > 0) {
            ((AtomicIntegerAssert)Assertions.assertThat((AtomicInteger)this.onSuccessCount).withFailMessage("onSuccess signaled multiple times", new Object[0])).hasValueLessThan(2);
            ((AtomicIntegerAssert)Assertions.assertThat((AtomicInteger)this.onErrorCount).withFailMessage("Both onSuccess and onError were signaled", new Object[0])).hasValue(0);
            return (V)(this.result == NULL_SENTINEL ? null : this.result);
        }
        if (this.onErrorCount.get() > 0) {
            ((ObjectAssert)Assertions.assertThat((Object)this.error).withFailMessage("onError signaled with null", new Object[0])).isNotSameAs(NULL_SENTINEL);
            throw new AssertionError("expected onSuccess, but received onError(" + this.error + ")", (Throwable)this.error);
        }
        throw new AssertionError((Object)"unexpected state");
    }

    void awaitUninterruptably() {
        try {
            this.await(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void accept(V v, Throwable throwable) {
        if (throwable != null) {
            this.onError(throwable);
        } else {
            this.onSuccess(v);
        }
    }
}

