/*
 * Decompiled with CFR 0.152.
 */
package brave.spring.beans;

import brave.Clock;
import brave.ErrorParser;
import brave.Tracing;
import brave.TracingCustomizer;
import brave.handler.FinishedSpanHandler;
import brave.propagation.CurrentTraceContext;
import brave.propagation.Propagation;
import brave.sampler.Sampler;
import java.util.List;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import zipkin2.Endpoint;
import zipkin2.Span;
import zipkin2.reporter.Reporter;

public class TracingFactoryBean
extends AbstractFactoryBean {
    String localServiceName;
    Endpoint localEndpoint;
    Endpoint endpoint;
    Reporter<Span> spanReporter;
    List<FinishedSpanHandler> finishedSpanHandlers;
    Clock clock;
    Sampler sampler;
    ErrorParser errorParser;
    CurrentTraceContext currentTraceContext;
    Propagation.Factory propagationFactory;
    Boolean traceId128Bit;
    Boolean supportsJoin;
    List<TracingCustomizer> customizers;

    protected Tracing createInstance() {
        Tracing.Builder builder = Tracing.newBuilder();
        if (this.localServiceName != null) {
            builder.localServiceName(this.localServiceName);
        }
        if (this.localEndpoint != null) {
            builder.endpoint(this.localEndpoint);
        }
        if (this.endpoint != null) {
            builder.endpoint(this.endpoint);
        }
        if (this.spanReporter != null) {
            builder.spanReporter(this.spanReporter);
        }
        if (this.finishedSpanHandlers != null) {
            for (FinishedSpanHandler finishedSpanHandler : this.finishedSpanHandlers) {
                builder.addFinishedSpanHandler(finishedSpanHandler);
            }
        }
        if (this.errorParser != null) {
            builder.errorParser(this.errorParser);
        }
        if (this.clock != null) {
            builder.clock(this.clock);
        }
        if (this.sampler != null) {
            builder.sampler(this.sampler);
        }
        if (this.currentTraceContext != null) {
            builder.currentTraceContext(this.currentTraceContext);
        }
        if (this.propagationFactory != null) {
            builder.propagationFactory(this.propagationFactory);
        }
        if (this.traceId128Bit != null) {
            builder.traceId128Bit(this.traceId128Bit.booleanValue());
        }
        if (this.supportsJoin != null) {
            builder.supportsJoin(this.supportsJoin.booleanValue());
        }
        if (this.customizers != null) {
            for (TracingCustomizer customizer : this.customizers) {
                customizer.customize(builder);
            }
        }
        return builder.build();
    }

    protected void destroyInstance(Object instance) {
        ((Tracing)instance).close();
    }

    public Class<? extends Tracing> getObjectType() {
        return Tracing.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setLocalServiceName(String localServiceName) {
        this.localServiceName = localServiceName;
    }

    public void setLocalEndpoint(Endpoint localEndpoint) {
        this.localEndpoint = localEndpoint;
    }

    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public void setSpanReporter(Reporter<Span> spanReporter) {
        this.spanReporter = spanReporter;
    }

    public List<FinishedSpanHandler> getFinishedSpanHandlers() {
        return this.finishedSpanHandlers;
    }

    public void setFinishedSpanHandlers(List<FinishedSpanHandler> finishedSpanHandlers) {
        this.finishedSpanHandlers = finishedSpanHandlers;
    }

    public void setClock(Clock clock) {
        this.clock = clock;
    }

    public void setErrorParser(ErrorParser errorParser) {
        this.errorParser = errorParser;
    }

    public void setSampler(Sampler sampler) {
        this.sampler = sampler;
    }

    public void setCurrentTraceContext(CurrentTraceContext currentTraceContext) {
        this.currentTraceContext = currentTraceContext;
    }

    public void setPropagationFactory(Propagation.Factory propagationFactory) {
        this.propagationFactory = propagationFactory;
    }

    public void setTraceId128Bit(boolean traceId128Bit) {
        this.traceId128Bit = traceId128Bit;
    }

    public void setSupportsJoin(Boolean supportsJoin) {
        this.supportsJoin = supportsJoin;
    }

    public void setCustomizers(List<TracingCustomizer> customizers) {
        this.customizers = customizers;
    }
}

