/*
 * Decompiled with CFR 0.152.
 */
package brave.rpc;

import brave.Tracing;
import brave.rpc.RpcRequest;
import brave.sampler.SamplerFunction;
import brave.sampler.SamplerFunctions;

public class RpcTracing {
    final Tracing tracing;
    final SamplerFunction<RpcRequest> clientSampler;
    final SamplerFunction<RpcRequest> serverSampler;

    public static RpcTracing create(Tracing tracing) {
        return RpcTracing.newBuilder(tracing).build();
    }

    public static Builder newBuilder(Tracing tracing) {
        return new Builder(tracing);
    }

    public Tracing tracing() {
        return this.tracing;
    }

    public SamplerFunction<RpcRequest> clientSampler() {
        return this.clientSampler;
    }

    public SamplerFunction<RpcRequest> serverSampler() {
        return this.serverSampler;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    RpcTracing(Builder builder) {
        this.tracing = builder.tracing;
        this.clientSampler = builder.clientSampler;
        this.serverSampler = builder.serverSampler;
    }

    public static final class Builder {
        Tracing tracing;
        SamplerFunction<RpcRequest> clientSampler;
        SamplerFunction<RpcRequest> serverSampler;

        Builder(Tracing tracing) {
            if (tracing == null) {
                throw new NullPointerException("tracing == null");
            }
            this.tracing = tracing;
            this.clientSampler = SamplerFunctions.deferDecision();
            this.serverSampler = SamplerFunctions.deferDecision();
        }

        Builder(RpcTracing source) {
            this.tracing = source.tracing;
            this.clientSampler = source.clientSampler;
            this.serverSampler = source.serverSampler;
        }

        public Builder tracing(Tracing tracing) {
            if (tracing == null) {
                throw new NullPointerException("tracing == null");
            }
            this.tracing = tracing;
            return this;
        }

        public Builder clientSampler(SamplerFunction<RpcRequest> clientSampler) {
            if (clientSampler == null) {
                throw new NullPointerException("clientSampler == null");
            }
            this.clientSampler = clientSampler;
            return this;
        }

        public Builder serverSampler(SamplerFunction<RpcRequest> serverSampler) {
            if (serverSampler == null) {
                throw new NullPointerException("serverSampler == null");
            }
            this.serverSampler = serverSampler;
            return this;
        }

        public RpcTracing build() {
            return new RpcTracing(this);
        }
    }
}

