/*
 * Decompiled with CFR 0.152.
 */
package brave.kafka.streams;

import brave.Span;
import brave.Tracer;
import brave.kafka.streams.KafkaStreamsTracing;
import org.apache.kafka.streams.kstream.ValueTransformerWithKey;
import org.apache.kafka.streams.processor.ProcessorContext;
import zipkin2.Call;

class TracingValueTransformerWithKey<K, V, VR>
implements ValueTransformerWithKey<K, V, VR> {
    final KafkaStreamsTracing kafkaStreamsTracing;
    final Tracer tracer;
    final String spanName;
    final ValueTransformerWithKey<K, V, VR> delegateTransformer;
    ProcessorContext processorContext;

    TracingValueTransformerWithKey(KafkaStreamsTracing kafkaStreamsTracing, String spanName, ValueTransformerWithKey<K, V, VR> delegateTransformer) {
        this.kafkaStreamsTracing = kafkaStreamsTracing;
        this.tracer = kafkaStreamsTracing.tracer;
        this.spanName = spanName;
        this.delegateTransformer = delegateTransformer;
    }

    public void init(ProcessorContext processorContext) {
        this.processorContext = processorContext;
        this.delegateTransformer.init(processorContext);
    }

    public VR transform(K k, V v) {
        Span span = this.kafkaStreamsTracing.nextSpan(this.processorContext);
        if (!span.isNoop()) {
            span.name(this.spanName);
            span.start();
        }
        Tracer.SpanInScope ws = this.tracer.withSpanInScope(span);
        Throwable error = null;
        try {
            Object object = this.delegateTransformer.transform(k, v);
            return (VR)object;
        }
        catch (Throwable e) {
            error = e;
            Call.propagateIfFatal((Throwable)e);
            throw e;
        }
        finally {
            this.kafkaStreamsTracing.injector.inject(span.context(), (Object)this.processorContext.headers());
            if (error != null) {
                span.error(error);
            }
            span.finish();
            ws.close();
        }
    }

    public void close() {
        this.delegateTransformer.close();
    }
}

