/*
 * Decompiled with CFR 0.152.
 */
package brave.jms;

import brave.Span;
import brave.Tracer;
import brave.jms.JmsTracing;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;

final class TracingExceptionListener {
    TracingExceptionListener() {
    }

    static ExceptionListener create(JmsTracing jmsTracing) {
        return new TagError(jmsTracing.tracing.tracer());
    }

    static ExceptionListener create(ExceptionListener delegate, JmsTracing jmsTracing) {
        if (delegate == null) {
            throw new NullPointerException("exceptionListener == null");
        }
        if (delegate instanceof TagError) {
            return delegate;
        }
        return new DelegateAndTagError(delegate, jmsTracing.tracing.tracer());
    }

    static class TagError
    implements ExceptionListener {
        final Tracer tracer;

        TagError(Tracer tracer) {
            this.tracer = tracer;
        }

        public void onException(JMSException exception) {
            Span span = this.tracer.currentSpan();
            if (span != null) {
                span.error((Throwable)exception);
            }
        }
    }

    static final class DelegateAndTagError
    extends TagError {
        final ExceptionListener delegate;

        DelegateAndTagError(ExceptionListener delegate, Tracer tracer) {
            super(tracer);
            this.delegate = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void onException(JMSException exception) {
            Span span = this.tracer.currentSpan();
            if (span == null) {
                this.delegate.onException(exception);
                return;
            }
            try {
                Tracer.SpanInScope ws = this.tracer.withSpanInScope(span);
                try {
                    this.delegate.onException(exception);
                    if (ws == null) return;
                }
                catch (Throwable throwable) {
                    if (ws == null) throw throwable;
                    try {
                        ws.close();
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                    }
                    throw throwable;
                }
                ws.close();
                return;
            }
            finally {
                span.error((Throwable)exception);
            }
        }
    }
}

