/*
 * Decompiled with CFR 0.152.
 */
package brave.jakarta.jms;

import brave.internal.Nullable;
import brave.internal.Throwables;
import brave.jakarta.jms.JmsTracing;
import jakarta.jms.Message;

class MessageProperties {
    MessageProperties() {
    }

    @Nullable
    static String getPropertyIfString(Message message, String name) {
        try {
            Object o = message.getObjectProperty(name);
            if (o instanceof String) {
                return o.toString();
            }
            return null;
        }
        catch (Throwable t) {
            Throwables.propagateIfFatal((Throwable)t);
            JmsTracing.log(t, "error getting property {0} from message {1}", name, message);
            return null;
        }
    }

    static void setStringProperty(Message message, String name, String value) {
        try {
            message.setStringProperty(name, value);
        }
        catch (Throwable t) {
            Throwables.propagateIfFatal((Throwable)t);
            JmsTracing.log(t, "error setting property {0} on message {1}", name, message);
        }
    }
}

