/*
 * Decompiled with CFR 0.152.
 */
package brave.jaxrs2;

import brave.Span;
import brave.Tracer;
import brave.http.HttpClientAdapter;
import brave.http.HttpClientHandler;
import brave.http.HttpTracing;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.ws.rs.ConstrainedTo;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;

@Provider
@ConstrainedTo(value=RuntimeType.CLIENT)
@Priority(value=0)
final class TracingClientFilter
implements ClientRequestFilter,
ClientResponseFilter {
    static final Propagation.Setter<MultivaluedMap<String, Object>, String> SETTER = new Propagation.Setter<MultivaluedMap<String, Object>, String>(){

        public void put(MultivaluedMap<String, Object> carrier, String key, String value) {
            carrier.putSingle((Object)key, (Object)value);
        }

        public String toString() {
            return "MultivaluedMap::putSingle";
        }
    };
    final Tracer tracer;
    final HttpClientHandler<ClientRequestContext, ClientResponseContext> handler;
    final TraceContext.Injector<MultivaluedMap<String, Object>> injector;

    @Inject
    TracingClientFilter(HttpTracing httpTracing) {
        if (httpTracing == null) {
            throw new NullPointerException("HttpTracing == null");
        }
        this.tracer = httpTracing.tracing().tracer();
        this.handler = HttpClientHandler.create((HttpTracing)httpTracing, (HttpClientAdapter)new HttpAdapter());
        this.injector = httpTracing.tracing().propagation().injector(SETTER);
    }

    public void filter(ClientRequestContext request) {
        Span span = this.handler.handleSend(this.injector, (Object)request.getHeaders(), (Object)request);
        request.setProperty(Tracer.SpanInScope.class.getName(), (Object)this.tracer.withSpanInScope(span));
    }

    public void filter(ClientRequestContext request, ClientResponseContext response) {
        Span span = this.tracer.currentSpan();
        if (span == null) {
            return;
        }
        ((Tracer.SpanInScope)request.getProperty(Tracer.SpanInScope.class.getName())).close();
        this.handler.handleReceive((Object)response, null, span);
    }

    static final class HttpAdapter
    extends HttpClientAdapter<ClientRequestContext, ClientResponseContext> {
        HttpAdapter() {
        }

        public String method(ClientRequestContext request) {
            return request.getMethod();
        }

        public String path(ClientRequestContext request) {
            return request.getUri().getPath();
        }

        public String url(ClientRequestContext request) {
            return request.getUri().toString();
        }

        public String requestHeader(ClientRequestContext request, String name) {
            return request.getHeaderString(name);
        }

        public Integer statusCode(ClientResponseContext response) {
            return response.getStatus();
        }
    }
}

