/*
 * Decompiled with CFR 0.152.
 */
package brave.grpc;

import brave.grpc.GrpcParser;
import brave.grpc.GrpcRequest;
import brave.rpc.RpcServerRequest;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCall;
import java.util.Map;

public class GrpcServerRequest
extends RpcServerRequest
implements GrpcRequest {
    final Map<String, Metadata.Key<String>> nameToKey;
    final ServerCall<?, ?> call;
    final Metadata headers;

    GrpcServerRequest(Map<String, Metadata.Key<String>> nameToKey, ServerCall<?, ?> call, Metadata headers) {
        if (nameToKey == null) {
            throw new NullPointerException("nameToKey == null");
        }
        if (call == null) {
            throw new NullPointerException("call == null");
        }
        if (headers == null) {
            throw new NullPointerException("headers == null");
        }
        this.nameToKey = nameToKey;
        this.call = call;
        this.headers = headers;
    }

    public Object unwrap() {
        return this.call;
    }

    public String method() {
        return GrpcParser.method(this.call.getMethodDescriptor().getFullMethodName());
    }

    public String service() {
        return GrpcParser.service(this.call.getMethodDescriptor().getFullMethodName());
    }

    public ServerCall<?, ?> call() {
        return this.call;
    }

    @Override
    public MethodDescriptor<?, ?> methodDescriptor() {
        return this.call.getMethodDescriptor();
    }

    @Override
    public Metadata headers() {
        return this.headers;
    }

    protected String propagationField(String keyName) {
        if (keyName == null) {
            throw new NullPointerException("keyName == null");
        }
        Metadata.Key<String> key = this.nameToKey.get(keyName);
        if (key == null) {
            assert (false) : "We currently don't support getting headers except propagation fields";
            return null;
        }
        return (String)this.headers.get(key);
    }
}

