/*
 * Decompiled with CFR 0.152.
 */
package brave.grpc;

import brave.grpc.GrpcClientRequest;
import brave.grpc.GrpcResponse;
import brave.internal.Nullable;
import brave.rpc.RpcClientResponse;
import io.grpc.Metadata;
import io.grpc.Status;

public final class GrpcClientResponse
extends RpcClientResponse
implements GrpcResponse {
    final GrpcClientRequest request;
    final Metadata headers;
    final Status status;
    final Metadata trailers;

    GrpcClientResponse(GrpcClientRequest request, Metadata headers, Status status, Metadata trailers) {
        if (request == null) {
            throw new NullPointerException("request == null");
        }
        if (headers == null) {
            throw new NullPointerException("headers == null");
        }
        if (status == null) {
            throw new NullPointerException("status == null");
        }
        if (trailers == null) {
            throw new NullPointerException("trailers == null");
        }
        this.headers = headers;
        this.request = request;
        this.status = status;
        this.trailers = trailers;
    }

    public Status unwrap() {
        return this.status;
    }

    public GrpcClientRequest request() {
        return this.request;
    }

    @Nullable
    public Throwable error() {
        return this.status.getCause();
    }

    @Nullable
    public String errorCode() {
        if (this.status.isOk()) {
            return null;
        }
        return this.status.getCode().name();
    }

    @Override
    public Metadata headers() {
        return this.headers;
    }

    @Override
    public Status status() {
        return this.status;
    }

    @Override
    public Metadata trailers() {
        return this.trailers;
    }
}

