/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.rbac.api;

import io.weaviate.client.v1.rbac.model.AliasPermission;
import io.weaviate.client.v1.rbac.model.BackupsPermission;
import io.weaviate.client.v1.rbac.model.CollectionsPermission;
import io.weaviate.client.v1.rbac.model.DataPermission;
import io.weaviate.client.v1.rbac.model.GroupsPermission;
import io.weaviate.client.v1.rbac.model.NodesPermission;
import io.weaviate.client.v1.rbac.model.Permission;
import io.weaviate.client.v1.rbac.model.ReplicatePermission;
import io.weaviate.client.v1.rbac.model.RolesPermission;
import io.weaviate.client.v1.rbac.model.TenantsPermission;
import io.weaviate.client.v1.rbac.model.UsersPermission;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public class WeaviatePermission {
    String action;
    AliasPermission aliases;
    BackupsPermission backups;
    CollectionsPermission collections;
    DataPermission data;
    GroupsPermission groups;
    NodesPermission nodes;
    RolesPermission roles;
    TenantsPermission tenants;
    UsersPermission users;
    ReplicatePermission replicate;

    public WeaviatePermission(String action) {
        this.action = action;
    }

    public <P extends Permission<P>> WeaviatePermission(String action, Permission<P> perm) {
        this.action = action;
        if (perm instanceof AliasPermission) {
            this.aliases = (AliasPermission)perm;
        } else if (perm instanceof BackupsPermission) {
            this.backups = (BackupsPermission)perm;
        } else if (perm instanceof CollectionsPermission) {
            this.collections = (CollectionsPermission)perm;
        } else if (perm instanceof DataPermission) {
            this.data = (DataPermission)perm;
        } else if (perm instanceof GroupsPermission) {
            this.groups = (GroupsPermission)perm;
        } else if (perm instanceof NodesPermission) {
            this.nodes = (NodesPermission)perm;
        } else if (perm instanceof RolesPermission) {
            this.roles = (RolesPermission)perm;
        } else if (perm instanceof TenantsPermission) {
            this.tenants = (TenantsPermission)perm;
        } else if (perm instanceof UsersPermission) {
            this.users = (UsersPermission)perm;
        } else if (perm instanceof ReplicatePermission) {
            this.replicate = (ReplicatePermission)perm;
        }
    }

    public static List<WeaviatePermission> mergePermissions(List<Permission<?>> permissions) {
        ArrayList<WeaviatePermission> merged = new ArrayList<WeaviatePermission>();
        for (Permission<?> perm : permissions) {
            merged.addAll(perm.toWeaviate());
        }
        return merged;
    }

    @Generated
    public static WeaviatePermissionBuilder builder() {
        return new WeaviatePermissionBuilder();
    }

    @Generated
    public String getAction() {
        return this.action;
    }

    @Generated
    public AliasPermission getAliases() {
        return this.aliases;
    }

    @Generated
    public BackupsPermission getBackups() {
        return this.backups;
    }

    @Generated
    public CollectionsPermission getCollections() {
        return this.collections;
    }

    @Generated
    public DataPermission getData() {
        return this.data;
    }

    @Generated
    public GroupsPermission getGroups() {
        return this.groups;
    }

    @Generated
    public NodesPermission getNodes() {
        return this.nodes;
    }

    @Generated
    public RolesPermission getRoles() {
        return this.roles;
    }

    @Generated
    public TenantsPermission getTenants() {
        return this.tenants;
    }

    @Generated
    public UsersPermission getUsers() {
        return this.users;
    }

    @Generated
    public ReplicatePermission getReplicate() {
        return this.replicate;
    }

    @Generated
    public WeaviatePermission(String action, AliasPermission aliases, BackupsPermission backups, CollectionsPermission collections, DataPermission data, GroupsPermission groups, NodesPermission nodes, RolesPermission roles, TenantsPermission tenants, UsersPermission users, ReplicatePermission replicate) {
        this.action = action;
        this.aliases = aliases;
        this.backups = backups;
        this.collections = collections;
        this.data = data;
        this.groups = groups;
        this.nodes = nodes;
        this.roles = roles;
        this.tenants = tenants;
        this.users = users;
        this.replicate = replicate;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WeaviatePermission)) {
            return false;
        }
        WeaviatePermission other = (WeaviatePermission)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$action = this.getAction();
        String other$action = other.getAction();
        if (this$action == null ? other$action != null : !this$action.equals(other$action)) {
            return false;
        }
        AliasPermission this$aliases = this.getAliases();
        AliasPermission other$aliases = other.getAliases();
        if (this$aliases == null ? other$aliases != null : !((Object)this$aliases).equals(other$aliases)) {
            return false;
        }
        BackupsPermission this$backups = this.getBackups();
        BackupsPermission other$backups = other.getBackups();
        if (this$backups == null ? other$backups != null : !((Object)this$backups).equals(other$backups)) {
            return false;
        }
        CollectionsPermission this$collections = this.getCollections();
        CollectionsPermission other$collections = other.getCollections();
        if (this$collections == null ? other$collections != null : !((Object)this$collections).equals(other$collections)) {
            return false;
        }
        DataPermission this$data = this.getData();
        DataPermission other$data = other.getData();
        if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
            return false;
        }
        GroupsPermission this$groups = this.getGroups();
        GroupsPermission other$groups = other.getGroups();
        if (this$groups == null ? other$groups != null : !((Object)this$groups).equals(other$groups)) {
            return false;
        }
        NodesPermission this$nodes = this.getNodes();
        NodesPermission other$nodes = other.getNodes();
        if (this$nodes == null ? other$nodes != null : !((Object)this$nodes).equals(other$nodes)) {
            return false;
        }
        RolesPermission this$roles = this.getRoles();
        RolesPermission other$roles = other.getRoles();
        if (this$roles == null ? other$roles != null : !((Object)this$roles).equals(other$roles)) {
            return false;
        }
        TenantsPermission this$tenants = this.getTenants();
        TenantsPermission other$tenants = other.getTenants();
        if (this$tenants == null ? other$tenants != null : !((Object)this$tenants).equals(other$tenants)) {
            return false;
        }
        UsersPermission this$users = this.getUsers();
        UsersPermission other$users = other.getUsers();
        if (this$users == null ? other$users != null : !((Object)this$users).equals(other$users)) {
            return false;
        }
        ReplicatePermission this$replicate = this.getReplicate();
        ReplicatePermission other$replicate = other.getReplicate();
        return !(this$replicate == null ? other$replicate != null : !((Object)this$replicate).equals(other$replicate));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WeaviatePermission;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : $action.hashCode());
        AliasPermission $aliases = this.getAliases();
        result = result * 59 + ($aliases == null ? 43 : ((Object)$aliases).hashCode());
        BackupsPermission $backups = this.getBackups();
        result = result * 59 + ($backups == null ? 43 : ((Object)$backups).hashCode());
        CollectionsPermission $collections = this.getCollections();
        result = result * 59 + ($collections == null ? 43 : ((Object)$collections).hashCode());
        DataPermission $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        GroupsPermission $groups = this.getGroups();
        result = result * 59 + ($groups == null ? 43 : ((Object)$groups).hashCode());
        NodesPermission $nodes = this.getNodes();
        result = result * 59 + ($nodes == null ? 43 : ((Object)$nodes).hashCode());
        RolesPermission $roles = this.getRoles();
        result = result * 59 + ($roles == null ? 43 : ((Object)$roles).hashCode());
        TenantsPermission $tenants = this.getTenants();
        result = result * 59 + ($tenants == null ? 43 : ((Object)$tenants).hashCode());
        UsersPermission $users = this.getUsers();
        result = result * 59 + ($users == null ? 43 : ((Object)$users).hashCode());
        ReplicatePermission $replicate = this.getReplicate();
        result = result * 59 + ($replicate == null ? 43 : ((Object)$replicate).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "WeaviatePermission(action=" + this.getAction() + ", aliases=" + this.getAliases() + ", backups=" + this.getBackups() + ", collections=" + this.getCollections() + ", data=" + this.getData() + ", groups=" + this.getGroups() + ", nodes=" + this.getNodes() + ", roles=" + this.getRoles() + ", tenants=" + this.getTenants() + ", users=" + this.getUsers() + ", replicate=" + this.getReplicate() + ")";
    }

    @Generated
    public static class WeaviatePermissionBuilder {
        @Generated
        private String action;
        @Generated
        private AliasPermission aliases;
        @Generated
        private BackupsPermission backups;
        @Generated
        private CollectionsPermission collections;
        @Generated
        private DataPermission data;
        @Generated
        private GroupsPermission groups;
        @Generated
        private NodesPermission nodes;
        @Generated
        private RolesPermission roles;
        @Generated
        private TenantsPermission tenants;
        @Generated
        private UsersPermission users;
        @Generated
        private ReplicatePermission replicate;

        @Generated
        WeaviatePermissionBuilder() {
        }

        @Generated
        public WeaviatePermissionBuilder action(String action) {
            this.action = action;
            return this;
        }

        @Generated
        public WeaviatePermissionBuilder aliases(AliasPermission aliases) {
            this.aliases = aliases;
            return this;
        }

        @Generated
        public WeaviatePermissionBuilder backups(BackupsPermission backups) {
            this.backups = backups;
            return this;
        }

        @Generated
        public WeaviatePermissionBuilder collections(CollectionsPermission collections) {
            this.collections = collections;
            return this;
        }

        @Generated
        public WeaviatePermissionBuilder data(DataPermission data) {
            this.data = data;
            return this;
        }

        @Generated
        public WeaviatePermissionBuilder groups(GroupsPermission groups) {
            this.groups = groups;
            return this;
        }

        @Generated
        public WeaviatePermissionBuilder nodes(NodesPermission nodes) {
            this.nodes = nodes;
            return this;
        }

        @Generated
        public WeaviatePermissionBuilder roles(RolesPermission roles) {
            this.roles = roles;
            return this;
        }

        @Generated
        public WeaviatePermissionBuilder tenants(TenantsPermission tenants) {
            this.tenants = tenants;
            return this;
        }

        @Generated
        public WeaviatePermissionBuilder users(UsersPermission users) {
            this.users = users;
            return this;
        }

        @Generated
        public WeaviatePermissionBuilder replicate(ReplicatePermission replicate) {
            this.replicate = replicate;
            return this;
        }

        @Generated
        public WeaviatePermission build() {
            return new WeaviatePermission(this.action, this.aliases, this.backups, this.collections, this.data, this.groups, this.nodes, this.roles, this.tenants, this.users, this.replicate);
        }

        @Generated
        public String toString() {
            return "WeaviatePermission.WeaviatePermissionBuilder(action=" + this.action + ", aliases=" + this.aliases + ", backups=" + this.backups + ", collections=" + this.collections + ", data=" + this.data + ", groups=" + this.groups + ", nodes=" + this.nodes + ", roles=" + this.roles + ", tenants=" + this.tenants + ", users=" + this.users + ", replicate=" + this.replicate + ")";
        }
    }
}

