/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.cluster.api;

import com.google.gson.annotations.SerializedName;
import io.weaviate.client.Config;
import io.weaviate.client.base.BaseClient;
import io.weaviate.client.base.ClientResult;
import io.weaviate.client.base.Result;
import io.weaviate.client.base.http.HttpClient;
import io.weaviate.client.base.util.UrlEncoder;
import io.weaviate.client.v1.cluster.model.ShardingState;
import lombok.Generated;

public class ShardingStateQuerier
extends BaseClient<ResponseBody>
implements ClientResult<ShardingState> {
    private String className;
    private String shard;

    public ShardingStateQuerier(HttpClient httpClient, Config config) {
        super(httpClient, config);
    }

    public ShardingStateQuerier withClassName(String className) {
        this.className = className;
        return this;
    }

    public ShardingStateQuerier withShard(String shard) {
        this.shard = shard;
        return this;
    }

    @Override
    public Result<ShardingState> run() {
        String path = "/replication/sharding-state?" + UrlEncoder.encodeQueryParam("collection", this.className);
        if (this.shard != null) {
            path = path + "&" + UrlEncoder.encodeQueryParam("shard", this.shard);
        }
        return Result.map(this.sendGetRequest(path, ResponseBody.class), ResponseBody::getState);
    }

    static class ResponseBody {
        @SerializedName(value="shardingState")
        ShardingState state;

        ResponseBody() {
        }

        @Generated
        public ShardingState getState() {
            return this.state;
        }
    }
}

