/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.async.cluster.api;

import com.google.gson.annotations.SerializedName;
import io.weaviate.client.Config;
import io.weaviate.client.base.AsyncBaseClient;
import io.weaviate.client.base.AsyncClientResult;
import io.weaviate.client.base.Result;
import io.weaviate.client.v1.auth.provider.AccessTokenProvider;
import io.weaviate.client.v1.cluster.model.ReplicationType;
import java.util.concurrent.Future;
import lombok.Generated;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.core5.concurrent.FutureCallback;

public class Replicator
extends AsyncBaseClient<String>
implements AsyncClientResult<String> {
    private String className;
    private String shard;
    private String sourceNode;
    private String targetNode;
    private ReplicationType replicationType;

    public Replicator(CloseableHttpAsyncClient httpClient, Config config, AccessTokenProvider tokenProvider) {
        super(httpClient, config, tokenProvider);
    }

    public Replicator withClassName(String className) {
        this.className = className;
        return this;
    }

    public Replicator withShard(String shard) {
        this.shard = shard;
        return this;
    }

    public Replicator withSourceNode(String sourceNode) {
        this.sourceNode = sourceNode;
        return this;
    }

    public Replicator withTargetNode(String targetNode) {
        this.targetNode = targetNode;
        return this;
    }

    public Replicator withReplicationType(ReplicationType replicationType) {
        this.replicationType = replicationType;
        return this;
    }

    @Override
    public Future<Result<String>> run(FutureCallback<Result<String>> callback) {
        return this.sendPostRequest("/replication/replicate", (Object)new RequestBody(), callback, Result.mapParser(ResponseBody.class, ResponseBody::getReplicationId));
    }

    class RequestBody {
        @SerializedName(value="collection")
        String className;
        @SerializedName(value="shard")
        String shard;
        @SerializedName(value="sourceNode")
        String sourceNode;
        @SerializedName(value="targetNode")
        String targetNode;
        @SerializedName(value="type")
        ReplicationType replicationType;

        RequestBody() {
            this.className = Replicator.this.className;
            this.shard = Replicator.this.shard;
            this.sourceNode = Replicator.this.sourceNode;
            this.targetNode = Replicator.this.targetNode;
            this.replicationType = Replicator.this.replicationType;
        }
    }

    static class ResponseBody {
        @SerializedName(value="id")
        String replicationId;

        ResponseBody() {
        }

        @Generated
        public String getReplicationId() {
            return this.replicationId;
        }
    }
}

