/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.aliases.api;

import io.weaviate.client.Config;
import io.weaviate.client.base.BaseClient;
import io.weaviate.client.base.ClientResult;
import io.weaviate.client.base.Response;
import io.weaviate.client.base.Result;
import io.weaviate.client.base.http.HttpClient;
import io.weaviate.client.v1.aliases.model.Alias;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class AliasAllGetter
extends BaseClient<ResponseBody>
implements ClientResult<Map<String, Alias>> {
    private String className;

    public AliasAllGetter(HttpClient httpClient, Config config) {
        super(httpClient, config);
    }

    public AliasAllGetter withClassName(String className) {
        this.className = className;
        return this;
    }

    @Override
    public Result<Map<String, Alias>> run() {
        String path = "/aliases" + (this.className != null ? "?class=" + this.className : "");
        Response<ResponseBody> resp = this.sendGetRequest(path, ResponseBody.class);
        if (resp.getErrors() != null) {
            return new Result<Object>(resp, null);
        }
        Map aliases = resp.getBody().aliases.stream().collect(Collectors.toMap(Alias::getAlias, Function.identity()));
        return new Result<Map<String, Alias>>(resp, aliases);
    }

    static class ResponseBody {
        List<Alias> aliases;

        ResponseBody() {
        }
    }
}

