/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.schema.api;

import io.weaviate.client.Config;
import io.weaviate.client.base.BaseClient;
import io.weaviate.client.base.ClientResult;
import io.weaviate.client.base.Response;
import io.weaviate.client.base.Result;
import io.weaviate.client.base.http.HttpClient;
import io.weaviate.client.base.util.UrlEncoder;
import io.weaviate.client.v1.schema.api.ClassGetter;
import io.weaviate.client.v1.schema.model.WeaviateClass;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class VectorAdder
extends BaseClient<WeaviateClass>
implements ClientResult<Boolean> {
    private final ClassGetter getter;
    private String className;
    private Map<String, WeaviateClass.VectorConfig> addedVectors = new HashMap<String, WeaviateClass.VectorConfig>();

    public VectorAdder(HttpClient httpClient, Config config) {
        super(httpClient, config);
        this.getter = new ClassGetter(httpClient, config);
    }

    public VectorAdder withClassName(String className) {
        this.className = className;
        return this;
    }

    public VectorAdder withVectorConfig(String name, WeaviateClass.VectorConfig vector) {
        this.addedVectors.put(name, vector);
        return this;
    }

    public VectorAdder withVectorConfig(Map<String, WeaviateClass.VectorConfig> vectors) {
        this.addedVectors = Collections.unmodifiableMap(vectors);
        return this;
    }

    @Override
    public Result<Boolean> run() {
        Result<WeaviateClass> result = this.getter.withClassName(this.className).run();
        if (result.hasErrors()) {
            result.toErrorResult();
        }
        WeaviateClass cls = result.getResult();
        this.addedVectors.entrySet().stream().forEach(vector -> cls.getVectorConfig().putIfAbsent((String)vector.getKey(), (WeaviateClass.VectorConfig)vector.getValue()));
        String path = String.format("/schema/%s", UrlEncoder.encodePathParam(this.className));
        Response<WeaviateClass> resp = this.sendPutRequest(path, cls, WeaviateClass.class);
        return new Result<Boolean>(resp.getStatusCode(), resp.getStatusCode() == 200, resp.getErrors());
    }
}

