/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.rbac.model;

import io.weaviate.client.v1.rbac.api.WeaviatePermission;
import io.weaviate.client.v1.rbac.model.BackupsPermission;
import io.weaviate.client.v1.rbac.model.ClusterPermission;
import io.weaviate.client.v1.rbac.model.CollectionsPermission;
import io.weaviate.client.v1.rbac.model.DataPermission;
import io.weaviate.client.v1.rbac.model.NodesPermission;
import io.weaviate.client.v1.rbac.model.RbacAction;
import io.weaviate.client.v1.rbac.model.RolesPermission;
import io.weaviate.client.v1.rbac.model.TenantsPermission;
import io.weaviate.client.v1.rbac.model.UsersPermission;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public abstract class Permission<P extends Permission<P>> {
    final transient Set<String> actions = new LinkedHashSet<String>();

    public List<String> getActions() {
        return this.actions.stream().collect(Collectors.toList());
    }

    Permission(RbacAction ... actions) {
        this.actions.addAll(Arrays.stream(actions).map(RbacAction::getValue).collect(Collectors.toList()));
    }

    public WeaviatePermission firstToWeaviate() {
        if (this.actions.isEmpty()) {
            return null;
        }
        return this.toWeaviate(this.actions.iterator().next());
    }

    public List<WeaviatePermission> toWeaviate() {
        return this.actions.stream().map(this::toWeaviate).collect(Collectors.toList());
    }

    private WeaviatePermission toWeaviate(String action) {
        return new WeaviatePermission(action, this);
    }

    public static Permission<?> fromWeaviate(WeaviatePermission perm) {
        String action = perm.getAction();
        if (perm.getBackups() != null) {
            return new BackupsPermission(perm.getBackups().getCollection(), action);
        }
        if (perm.getCollections() != null) {
            return new CollectionsPermission(perm.getCollections().getCollection(), action);
        }
        if (perm.getData() != null) {
            return new DataPermission(perm.getData().getCollection(), action);
        }
        if (perm.getNodes() != null) {
            NodesPermission nodes = perm.getNodes();
            if (nodes.getCollection() != null) {
                return new NodesPermission(nodes.getCollection(), nodes.getVerbosity(), action);
            }
            return new NodesPermission(nodes.getVerbosity(), action);
        }
        if (perm.getRoles() != null) {
            RolesPermission roles = perm.getRoles();
            return new RolesPermission(roles.getRole(), roles.getScope(), action);
        }
        if (perm.getTenants() != null) {
            return new TenantsPermission(action);
        }
        if (RbacAction.isValid(ClusterPermission.Action.class, action)) {
            return new ClusterPermission(action);
        }
        if (RbacAction.isValid(UsersPermission.Action.class, action)) {
            return new UsersPermission(action);
        }
        return null;
    }

    public static final List<Permission<?>> merge(List<Permission<?>> permissions) {
        class Key {
            final int hash;
            final Class<?> cls;

            Key(Object object) {
                this.hash = HashCodeBuilder.reflectionHashCode((Object)object, (String[])new String[]{"actions"});
                this.cls = object.getClass();
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Key)) {
                    return false;
                }
                Key other = (Key)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (this.hash != other.hash) {
                    return false;
                }
                Class<?> this$cls = this.cls;
                Class<?> other$cls = other.cls;
                return !(this$cls == null ? other$cls != null : !this$cls.equals(other$cls));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Key;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + this.hash;
                Class<?> $cls = this.cls;
                result = result * 59 + ($cls == null ? 43 : $cls.hashCode());
                return result;
            }
        }
        LinkedHashMap result = new LinkedHashMap();
        for (Permission<?> perm : permissions) {
            Key key = new Key(perm);
            Permission<?> stored = result.putIfAbsent(key, perm);
            if (stored == null) continue;
            stored.actions.addAll(perm.actions);
        }
        return result.values().stream().collect(Collectors.toList());
    }

    public static BackupsPermission backups(String collection, BackupsPermission.Action ... actions) {
        Permission.checkDeprecation(actions);
        return new BackupsPermission(collection, actions);
    }

    public static ClusterPermission cluster(ClusterPermission.Action ... actions) {
        Permission.checkDeprecation(actions);
        return new ClusterPermission(actions);
    }

    public static CollectionsPermission collections(String collection, CollectionsPermission.Action ... actions) {
        Permission.checkDeprecation(actions);
        return new CollectionsPermission(collection, actions);
    }

    public static DataPermission data(String collection, DataPermission.Action ... actions) {
        Permission.checkDeprecation(actions);
        return new DataPermission(collection, actions);
    }

    public static NodesPermission nodes(NodesPermission.Verbosity verbosity, NodesPermission.Action ... actions) {
        Permission.checkDeprecation(actions);
        return new NodesPermission(verbosity, actions);
    }

    public static NodesPermission nodes(String collection, NodesPermission.Action ... actions) {
        Permission.checkDeprecation(actions);
        return new NodesPermission(collection, actions);
    }

    public static RolesPermission roles(String role, RolesPermission.Action ... actions) {
        Permission.checkDeprecation(actions);
        return new RolesPermission(role, actions);
    }

    public static TenantsPermission tenants(TenantsPermission.Action ... actions) {
        Permission.checkDeprecation(actions);
        return new TenantsPermission(actions);
    }

    public static UsersPermission users(UsersPermission.Action ... actions) {
        Permission.checkDeprecation(actions);
        return new UsersPermission(actions);
    }

    private static void checkDeprecation(RbacAction ... actions) throws IllegalArgumentException {
        for (RbacAction action : actions) {
            if (!action.isDeprecated()) continue;
            throw new IllegalArgumentException(action.getValue() + " is hard-deprecated and should only be used to read legacy permissions created in v1.28");
        }
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Permission)) {
            return false;
        }
        Permission other = (Permission)o;
        return other.canEqual(this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Permission;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    public String toString() {
        return "Permission(actions=" + this.getActions() + ")";
    }
}

