/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.graphql.query.argument;

import io.weaviate.client.v1.filters.WhereFilter;
import io.weaviate.client.v1.graphql.query.argument.Argument;
import io.weaviate.client.v1.graphql.query.util.Serializer;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.function.Function;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.time.DateFormatUtils;

public class WhereArgument
implements Argument {
    private final WhereFilter filter;

    @Override
    public String build() {
        String whereStr = this.filter != null ? this.buildNestedFilter(this.filter) : "";
        return String.format("where:{%s}", whereStr);
    }

    private String buildNestedFilter(WhereFilter f) {
        LinkedHashSet<String> args = new LinkedHashSet<String>();
        if (ArrayUtils.isNotEmpty((Object[])f.getOperands())) {
            if (f.getOperator() != null) {
                args.add(this.buildArg("operator", Serializer.escape(f.getOperator())));
            }
            args.add(this.buildArg("operands", Serializer.array(f.getOperands(), o -> String.format("{%s}", this.buildNestedFilter((WhereFilter)o)))));
        } else {
            if (ArrayUtils.isNotEmpty((Object[])f.getPath())) {
                args.add(this.buildArg("path", Serializer.arrayWithQuotes(f.getPath())));
            }
            this.addArgSingleOrArray("valueBoolean", f.getValueBoolean(), f.getValueBooleanArray(), args::add);
            this.addArgSingleOrArray("valueInt", f.getValueInt(), f.getValueIntArray(), args::add);
            this.addArgSingleOrArray("valueNumber", f.getValueNumber(), f.getValueNumberArray(), args::add);
            this.addArgSingleOrArray("valueString", f.getValueString(), f.getValueStringArray(), args::add, Serializer::quote);
            this.addArgSingleOrArray("valueText", f.getValueText(), f.getValueTextArray(), args::add, Serializer::quote);
            this.addArgSingleOrArray("valueDate", f.getValueDate(), f.getValueDateArray(), args::add, date -> {
                String dateString = DateFormatUtils.format((Date)date, (String)"yyyy-MM-dd'T'HH:mm:ssZZZZZ");
                return Serializer.quote(dateString);
            });
            if (f.getValueGeoRange() != null) {
                args.add(this.buildArg("valueGeoRange", this.buildGeoRange(f.getValueGeoRange())));
            }
            if (f.getOperator() != null) {
                args.add(this.buildArg("operator", Serializer.escape(f.getOperator())));
            }
        }
        return String.join((CharSequence)" ", args);
    }

    private String buildGeoRange(WhereFilter.GeoRange geoRange) {
        WhereFilter.GeoCoordinates geoCoordinates = geoRange.getGeoCoordinates();
        WhereFilter.GeoDistance distance = geoRange.getDistance();
        if (ObjectUtils.allNotNull((Object[])new Object[]{geoCoordinates, geoCoordinates.getLatitude(), geoCoordinates.getLongitude(), distance, distance.getMax()})) {
            return String.format("{geoCoordinates:{latitude:%s,longitude:%s},distance:{max:%s}}", geoCoordinates.getLatitude(), geoCoordinates.getLongitude(), distance.getMax());
        }
        return "";
    }

    private String buildArg(String name, Object value) {
        return String.format("%s:%s", name, value);
    }

    private <T> void addArgSingleOrArray(String valueName, T value, T[] values, Function<String, Boolean> add, Function<T, String> valueMapper) {
        String valAsString = null;
        if (Objects.nonNull(value)) {
            valAsString = valueMapper.apply(value);
        } else if (ArrayUtils.isNotEmpty((Object[])values)) {
            valAsString = Serializer.array(values, valueMapper);
        }
        if (Objects.nonNull(valAsString)) {
            add.apply(this.buildArg(valueName, valAsString));
        }
    }

    private <T> void addArgSingleOrArray(String valueName, T value, T[] values, Function<String, Boolean> add) {
        this.addArgSingleOrArray(valueName, value, values, add, Objects::toString);
    }

    @Generated
    WhereArgument(WhereFilter filter) {
        this.filter = filter;
    }

    @Generated
    public static WhereArgumentBuilder builder() {
        return new WhereArgumentBuilder();
    }

    @Generated
    public WhereFilter getFilter() {
        return this.filter;
    }

    @Generated
    public String toString() {
        return "WhereArgument(filter=" + this.getFilter() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WhereArgument)) {
            return false;
        }
        WhereArgument other = (WhereArgument)o;
        if (!other.canEqual(this)) {
            return false;
        }
        WhereFilter this$filter = this.getFilter();
        WhereFilter other$filter = other.getFilter();
        return !(this$filter == null ? other$filter != null : !((Object)this$filter).equals(other$filter));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WhereArgument;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        WhereFilter $filter = this.getFilter();
        result = result * 59 + ($filter == null ? 43 : ((Object)$filter).hashCode());
        return result;
    }

    @Generated
    public static class WhereArgumentBuilder {
        @Generated
        private WhereFilter filter;

        @Generated
        WhereArgumentBuilder() {
        }

        @Generated
        public WhereArgumentBuilder filter(WhereFilter filter) {
            this.filter = filter;
            return this;
        }

        @Generated
        public WhereArgument build() {
            return new WhereArgument(this.filter);
        }

        @Generated
        public String toString() {
            return "WhereArgument.WhereArgumentBuilder(filter=" + this.filter + ")";
        }
    }
}

