/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.graphql.query.argument;

import io.weaviate.client.v1.graphql.query.argument.Argument;
import io.weaviate.client.v1.graphql.query.argument.NearMediaArgumentHelper;
import java.io.File;
import java.util.Arrays;

public class NearImageArgument
implements Argument {
    private final String image;
    private final File imageFile;
    private final Float certainty;
    private final Float distance;
    private final String[] targetVectors;

    @Override
    public String build() {
        return NearMediaArgumentHelper.builder().certainty(this.certainty).distance(this.distance).targetVectors(this.targetVectors).data(this.image).dataFile(this.imageFile).mediaField("image").mediaName("nearImage").build().build();
    }

    NearImageArgument(String image, File imageFile, Float certainty, Float distance, String[] targetVectors) {
        this.image = image;
        this.imageFile = imageFile;
        this.certainty = certainty;
        this.distance = distance;
        this.targetVectors = targetVectors;
    }

    public static NearImageArgumentBuilder builder() {
        return new NearImageArgumentBuilder();
    }

    public String getImage() {
        return this.image;
    }

    public File getImageFile() {
        return this.imageFile;
    }

    public Float getCertainty() {
        return this.certainty;
    }

    public Float getDistance() {
        return this.distance;
    }

    public String[] getTargetVectors() {
        return this.targetVectors;
    }

    public String toString() {
        return "NearImageArgument(image=" + this.getImage() + ", imageFile=" + this.getImageFile() + ", certainty=" + this.getCertainty() + ", distance=" + this.getDistance() + ", targetVectors=" + Arrays.deepToString(this.getTargetVectors()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NearImageArgument)) {
            return false;
        }
        NearImageArgument other = (NearImageArgument)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Float this$certainty = this.getCertainty();
        Float other$certainty = other.getCertainty();
        if (this$certainty == null ? other$certainty != null : !((Object)this$certainty).equals(other$certainty)) {
            return false;
        }
        Float this$distance = this.getDistance();
        Float other$distance = other.getDistance();
        if (this$distance == null ? other$distance != null : !((Object)this$distance).equals(other$distance)) {
            return false;
        }
        String this$image = this.getImage();
        String other$image = other.getImage();
        if (this$image == null ? other$image != null : !this$image.equals(other$image)) {
            return false;
        }
        File this$imageFile = this.getImageFile();
        File other$imageFile = other.getImageFile();
        if (this$imageFile == null ? other$imageFile != null : !((Object)this$imageFile).equals(other$imageFile)) {
            return false;
        }
        return Arrays.deepEquals(this.getTargetVectors(), other.getTargetVectors());
    }

    protected boolean canEqual(Object other) {
        return other instanceof NearImageArgument;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Float $certainty = this.getCertainty();
        result = result * 59 + ($certainty == null ? 43 : ((Object)$certainty).hashCode());
        Float $distance = this.getDistance();
        result = result * 59 + ($distance == null ? 43 : ((Object)$distance).hashCode());
        String $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        File $imageFile = this.getImageFile();
        result = result * 59 + ($imageFile == null ? 43 : ((Object)$imageFile).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getTargetVectors());
        return result;
    }

    public static class NearImageArgumentBuilder {
        private String image;
        private File imageFile;
        private Float certainty;
        private Float distance;
        private String[] targetVectors;

        NearImageArgumentBuilder() {
        }

        public NearImageArgumentBuilder image(String image) {
            this.image = image;
            return this;
        }

        public NearImageArgumentBuilder imageFile(File imageFile) {
            this.imageFile = imageFile;
            return this;
        }

        public NearImageArgumentBuilder certainty(Float certainty) {
            this.certainty = certainty;
            return this;
        }

        public NearImageArgumentBuilder distance(Float distance) {
            this.distance = distance;
            return this;
        }

        public NearImageArgumentBuilder targetVectors(String[] targetVectors) {
            this.targetVectors = targetVectors;
            return this;
        }

        public NearImageArgument build() {
            return new NearImageArgument(this.image, this.imageFile, this.certainty, this.distance, this.targetVectors);
        }

        public String toString() {
            return "NearImageArgument.NearImageArgumentBuilder(image=" + this.image + ", imageFile=" + this.imageFile + ", certainty=" + this.certainty + ", distance=" + this.distance + ", targetVectors=" + Arrays.deepToString(this.targetVectors) + ")";
        }
    }
}

