/*
 * Decompiled with CFR 0.152.
 */
package io.vitess.client.grpc;

import io.grpc.stub.StreamObserver;
import io.vitess.client.StreamIterator;
import io.vitess.client.grpc.GrpcClient;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.util.NoSuchElementException;

abstract class GrpcStreamAdapter<V, E>
implements StreamObserver<V>,
StreamIterator<E>,
AutoCloseable {
    private E nextValue;
    private Throwable error;
    private boolean completed = false;
    private boolean closed = false;

    GrpcStreamAdapter() {
    }

    abstract E getResult(V var1) throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNext(V value) {
        GrpcStreamAdapter grpcStreamAdapter = this;
        synchronized (grpcStreamAdapter) {
            try {
                while (this.nextValue != null) {
                    if (this.closed || this.error != null) {
                        return;
                    }
                    this.wait();
                }
                this.nextValue = this.getResult(value);
                this.notifyAll();
            }
            catch (InterruptedException exc) {
                this.onError(exc);
            }
            catch (SQLException exc) {
                this.onError(exc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCompleted() {
        GrpcStreamAdapter grpcStreamAdapter = this;
        synchronized (grpcStreamAdapter) {
            this.completed = true;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onError(Throwable error) {
        GrpcStreamAdapter grpcStreamAdapter = this;
        synchronized (grpcStreamAdapter) {
            this.error = error;
            this.notifyAll();
        }
    }

    public boolean hasNext() throws SQLException {
        GrpcStreamAdapter grpcStreamAdapter = this;
        synchronized (grpcStreamAdapter) {
            try {
                while (this.nextValue == null) {
                    if (this.completed) {
                        return false;
                    }
                    if (this.error != null) {
                        throw GrpcClient.convertGrpcError(this.error);
                    }
                    this.wait();
                }
                return true;
            }
            catch (InterruptedException exc) {
                this.onError(exc);
                throw new SQLDataException("gRPC StreamIterator interrupted while waiting for value", exc);
            }
        }
    }

    public E next() throws NoSuchElementException, SQLException {
        GrpcStreamAdapter grpcStreamAdapter = this;
        synchronized (grpcStreamAdapter) {
            if (this.hasNext()) {
                E value = this.nextValue;
                this.nextValue = null;
                this.notifyAll();
                return value;
            }
            throw new NoSuchElementException("stream completed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        GrpcStreamAdapter grpcStreamAdapter = this;
        synchronized (grpcStreamAdapter) {
            this.closed = true;
        }
    }
}

