/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.unit.impl;

import io.vertx.core.Handler;
import io.vertx.ext.unit.TestContext;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Supplier;

public class Helper {
    public static void uncheckedThrow(Throwable throwable) {
        Helper.throwIt(throwable);
    }

    private static <T extends Throwable> void throwIt(Throwable throwable) throws T {
        throw throwable;
    }

    public static Handler<TestContext> invoker(Method method, Supplier<?> instance) {
        Class[] paramTypes = method.getParameterTypes();
        if (!(paramTypes.length == 0 || paramTypes.length == 1 && paramTypes[0].equals(TestContext.class))) {
            throw new IllegalArgumentException("Incorrect method handler mapping " + method);
        }
        return context -> {
            try {
                Object o = instance.get();
                if (paramTypes.length == 0) {
                    method.invoke(o, new Object[0]);
                } else {
                    method.invoke(o, context);
                }
            }
            catch (IllegalAccessException e) {
                Helper.uncheckedThrow(e);
            }
            catch (InvocationTargetException e) {
                Helper.uncheckedThrow(e.getCause());
            }
        };
    }
}

