/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.impl;

import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.annotations.NonNull;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.plugins.RxJavaPlugins;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;

public class AsyncResultSingle<T>
extends Single<T> {
    private final Consumer<Handler<AsyncResult<T>>> subscriptionConsumer;

    public static <T> Single<T> toSingle(Consumer<Handler<AsyncResult<T>>> subscriptionConsumer) {
        return RxJavaPlugins.onAssembly(new AsyncResultSingle<T>(subscriptionConsumer));
    }

    public AsyncResultSingle(Consumer<Handler<AsyncResult<T>>> subscriptionConsumer) {
        this.subscriptionConsumer = subscriptionConsumer;
    }

    protected void subscribeActual(@NonNull SingleObserver<? super T> observer) {
        block5: {
            final AtomicBoolean disposed = new AtomicBoolean();
            observer.onSubscribe(new Disposable(){

                public void dispose() {
                    disposed.set(true);
                }

                public boolean isDisposed() {
                    return disposed.get();
                }
            });
            if (!disposed.get()) {
                try {
                    this.subscriptionConsumer.accept(ar -> {
                        if (!disposed.getAndSet(true)) {
                            if (ar.succeeded()) {
                                try {
                                    observer.onSuccess(ar.result());
                                }
                                catch (Throwable t) {
                                    Exceptions.throwIfFatal((Throwable)t);
                                    RxJavaPlugins.onError((Throwable)t);
                                }
                            } else if (ar.failed()) {
                                try {
                                    observer.onError(ar.cause());
                                }
                                catch (Throwable t) {
                                    Exceptions.throwIfFatal((Throwable)t);
                                    RxJavaPlugins.onError((Throwable)t);
                                }
                            }
                        }
                    });
                }
                catch (Exception e) {
                    if (disposed.getAndSet(true)) break block5;
                    try {
                        observer.onError((Throwable)e);
                    }
                    catch (Throwable t) {
                        Exceptions.throwIfFatal((Throwable)t);
                        RxJavaPlugins.onError((Throwable)t);
                    }
                }
            }
        }
    }
}

