/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex;

import io.reactivex.Scheduler;
import io.vertx.core.Context;
import io.vertx.core.Vertx;
import io.vertx.core.WorkerExecutor;
import io.vertx.core.streams.WriteStream;
import io.vertx.reactivex.ContextScheduler;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import io.vertx.reactivex.impl.WriteStreamObserverImpl;
import io.vertx.reactivex.impl.WriteStreamSubscriberImpl;
import java.util.function.Function;

public class RxHelper {
    public static Scheduler scheduler(Vertx vertx) {
        return new ContextScheduler(vertx, false);
    }

    public static Scheduler scheduler(Context context) {
        return new ContextScheduler(context, false);
    }

    public static Scheduler blockingScheduler(Vertx vertx) {
        return new ContextScheduler(vertx, true);
    }

    public static Scheduler blockingScheduler(Vertx vertx, boolean ordered) {
        return new ContextScheduler(vertx, true, ordered);
    }

    public static Scheduler blockingScheduler(WorkerExecutor executor) {
        return new ContextScheduler(executor, false);
    }

    public static <T> WriteStreamSubscriber<T> toSubscriber(WriteStream<T> stream) {
        return RxHelper.toSubscriber(stream, Function.identity());
    }

    public static <R, T> WriteStreamSubscriber<R> toSubscriber(WriteStream<T> stream, Function<R, T> mapping) {
        return new WriteStreamSubscriberImpl<R, T>(stream, mapping);
    }

    public static <T> WriteStreamObserver<T> toObserver(WriteStream<T> stream) {
        return RxHelper.toObserver(stream, Function.identity());
    }

    public static <R, T> WriteStreamObserver<R> toObserver(WriteStream<T> stream, Function<R, T> mapping) {
        return new WriteStreamObserverImpl<R, T>(stream, mapping);
    }
}

