/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.core.file;

import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.Observable;
import io.reactivex.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import io.vertx.reactivex.core.streams.Pipe;
import io.vertx.reactivex.core.streams.ReadStream;
import io.vertx.reactivex.core.streams.WriteStream;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultSingle;
import java.util.function.Function;

@RxGen(value=io.vertx.core.file.AsyncFile.class)
public class AsyncFile
implements ReadStream<io.vertx.reactivex.core.buffer.Buffer>,
WriteStream<io.vertx.reactivex.core.buffer.Buffer> {
    public static final TypeArg<AsyncFile> __TYPE_ARG = new TypeArg(obj -> new AsyncFile((io.vertx.core.file.AsyncFile)obj), AsyncFile::getDelegate);
    private final io.vertx.core.file.AsyncFile delegate;
    private Observable<io.vertx.reactivex.core.buffer.Buffer> observable;
    private Flowable<io.vertx.reactivex.core.buffer.Buffer> flowable;
    private WriteStreamObserver<io.vertx.reactivex.core.buffer.Buffer> observer;
    private WriteStreamSubscriber<io.vertx.reactivex.core.buffer.Buffer> subscriber;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AsyncFile that = (AsyncFile)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public AsyncFile(io.vertx.core.file.AsyncFile delegate) {
        this.delegate = delegate;
    }

    public io.vertx.core.file.AsyncFile getDelegate() {
        return this.delegate;
    }

    @Override
    public synchronized Observable<io.vertx.reactivex.core.buffer.Buffer> toObservable() {
        if (this.observable == null) {
            Function<Buffer, io.vertx.reactivex.core.buffer.Buffer> conv = io.vertx.reactivex.core.buffer.Buffer::newInstance;
            this.observable = ObservableHelper.toObservable(this.delegate, conv);
        }
        return this.observable;
    }

    @Override
    public synchronized Flowable<io.vertx.reactivex.core.buffer.Buffer> toFlowable() {
        if (this.flowable == null) {
            Function<Buffer, io.vertx.reactivex.core.buffer.Buffer> conv = io.vertx.reactivex.core.buffer.Buffer::newInstance;
            this.flowable = FlowableHelper.toFlowable(this.delegate, conv);
        }
        return this.flowable;
    }

    public synchronized WriteStreamObserver<io.vertx.reactivex.core.buffer.Buffer> toObserver() {
        if (this.observer == null) {
            Function<io.vertx.reactivex.core.buffer.Buffer, Buffer> conv = io.vertx.reactivex.core.buffer.Buffer::getDelegate;
            this.observer = RxHelper.toObserver(this.getDelegate(), conv);
        }
        return this.observer;
    }

    public synchronized WriteStreamSubscriber<io.vertx.reactivex.core.buffer.Buffer> toSubscriber() {
        if (this.subscriber == null) {
            Function<io.vertx.reactivex.core.buffer.Buffer, Buffer> conv = io.vertx.reactivex.core.buffer.Buffer::getDelegate;
            this.subscriber = RxHelper.toSubscriber(this.getDelegate(), conv);
        }
        return this.subscriber;
    }

    @Override
    public void end(io.vertx.reactivex.core.buffer.Buffer data) {
        this.delegate.end((Object)data.getDelegate());
    }

    @Override
    public void end(io.vertx.reactivex.core.buffer.Buffer data, Handler<AsyncResult<Void>> handler) {
        this.delegate.end((Object)data.getDelegate(), handler);
    }

    public Completable rxEnd(io.vertx.reactivex.core.buffer.Buffer data) {
        return AsyncResultCompletable.toCompletable(handler -> this.end(data, (Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public boolean writeQueueFull() {
        boolean ret = this.delegate.writeQueueFull();
        return ret;
    }

    @Override
    public Pipe<io.vertx.reactivex.core.buffer.Buffer> pipe() {
        Pipe<io.vertx.reactivex.core.buffer.Buffer> ret = Pipe.newInstance(this.delegate.pipe(), io.vertx.reactivex.core.buffer.Buffer.__TYPE_ARG);
        return ret;
    }

    @Override
    public void pipeTo(WriteStream<io.vertx.reactivex.core.buffer.Buffer> dst) {
        this.delegate.pipeTo(dst.getDelegate());
    }

    @Override
    public void pipeTo(WriteStream<io.vertx.reactivex.core.buffer.Buffer> dst, Handler<AsyncResult<Void>> handler) {
        this.delegate.pipeTo(dst.getDelegate(), handler);
    }

    public Completable rxPipeTo(WriteStream<io.vertx.reactivex.core.buffer.Buffer> dst) {
        return AsyncResultCompletable.toCompletable(handler -> this.pipeTo(dst, (Handler<AsyncResult<Void>>)handler));
    }

    public AsyncFile handler(final Handler<io.vertx.reactivex.core.buffer.Buffer> handler) {
        this.delegate.handler((Handler)new Handler<Buffer>(){

            public void handle(Buffer event) {
                handler.handle((Object)io.vertx.reactivex.core.buffer.Buffer.newInstance(event));
            }
        });
        return this;
    }

    public AsyncFile pause() {
        this.delegate.pause();
        return this;
    }

    public AsyncFile resume() {
        this.delegate.resume();
        return this;
    }

    public AsyncFile endHandler(Handler<Void> endHandler) {
        this.delegate.endHandler(endHandler);
        return this;
    }

    public AsyncFile write(io.vertx.reactivex.core.buffer.Buffer data) {
        this.delegate.write(data.getDelegate());
        return this;
    }

    public AsyncFile write(io.vertx.reactivex.core.buffer.Buffer data, Handler<AsyncResult<Void>> handler) {
        this.delegate.write(data.getDelegate(), handler);
        return this;
    }

    public Completable rxWrite(io.vertx.reactivex.core.buffer.Buffer data) {
        return AsyncResultCompletable.toCompletable(handler -> this.write(data, (Handler<AsyncResult<Void>>)handler));
    }

    public AsyncFile setWriteQueueMaxSize(int maxSize) {
        this.delegate.setWriteQueueMaxSize(maxSize);
        return this;
    }

    public AsyncFile drainHandler(Handler<Void> handler) {
        this.delegate.drainHandler(handler);
        return this;
    }

    @Override
    public AsyncFile exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public AsyncFile fetch(long amount) {
        this.delegate.fetch(amount);
        return this;
    }

    @Override
    public void end() {
        this.delegate.end();
    }

    @Override
    public void end(Handler<AsyncResult<Void>> handler) {
        this.delegate.end(handler);
    }

    public Completable rxEnd() {
        return AsyncResultCompletable.toCompletable(handler -> this.end((Handler<AsyncResult<Void>>)handler));
    }

    public void close() {
        this.delegate.close();
    }

    public void close(Handler<AsyncResult<Void>> handler) {
        this.delegate.close(handler);
    }

    public Completable rxClose() {
        return AsyncResultCompletable.toCompletable(handler -> this.close((Handler<AsyncResult<Void>>)handler));
    }

    public AsyncFile write(io.vertx.reactivex.core.buffer.Buffer buffer, long position, Handler<AsyncResult<Void>> handler) {
        this.delegate.write(buffer.getDelegate(), position, handler);
        return this;
    }

    public Completable rxWrite(io.vertx.reactivex.core.buffer.Buffer buffer, long position) {
        return AsyncResultCompletable.toCompletable(handler -> this.write(buffer, position, (Handler<AsyncResult<Void>>)handler));
    }

    public AsyncFile read(io.vertx.reactivex.core.buffer.Buffer buffer, int offset, long position, int length, final Handler<AsyncResult<io.vertx.reactivex.core.buffer.Buffer>> handler) {
        this.delegate.read(buffer.getDelegate(), offset, position, length, (Handler)new Handler<AsyncResult<Buffer>>(){

            public void handle(AsyncResult<Buffer> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)io.vertx.reactivex.core.buffer.Buffer.newInstance((Buffer)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Single<io.vertx.reactivex.core.buffer.Buffer> rxRead(io.vertx.reactivex.core.buffer.Buffer buffer, int offset, long position, int length) {
        return AsyncResultSingle.toSingle(handler -> this.read(buffer, offset, position, length, (Handler<AsyncResult<io.vertx.reactivex.core.buffer.Buffer>>)handler));
    }

    public AsyncFile flush() {
        this.delegate.flush();
        return this;
    }

    public AsyncFile flush(Handler<AsyncResult<Void>> handler) {
        this.delegate.flush(handler);
        return this;
    }

    public Completable rxFlush() {
        return AsyncResultCompletable.toCompletable(handler -> this.flush((Handler<AsyncResult<Void>>)handler));
    }

    public AsyncFile setReadPos(long readPos) {
        this.delegate.setReadPos(readPos);
        return this;
    }

    public AsyncFile setWritePos(long writePos) {
        this.delegate.setWritePos(writePos);
        return this;
    }

    public long getWritePos() {
        long ret = this.delegate.getWritePos();
        return ret;
    }

    public AsyncFile setReadBufferSize(int readBufferSize) {
        this.delegate.setReadBufferSize(readBufferSize);
        return this;
    }

    public static AsyncFile newInstance(io.vertx.core.file.AsyncFile arg) {
        return arg != null ? new AsyncFile(arg) : null;
    }
}

