/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client.impl;

import io.vertx.redis.client.Command;
import io.vertx.redis.client.impl.KeyLocator;
import io.vertx.redis.client.impl.keys.KeyConsumer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class CommandImpl
implements Command {
    private final String command;
    private final byte[] bytes;
    private final int arity;
    private final KeyLocator[] keyLocators;
    private final boolean needGetKeys;
    private final Boolean readOnly;
    private final boolean pubsub;

    public CommandImpl(String command, int arity, Boolean readOnly, boolean pubsub, boolean needGetKeys, KeyLocator ... keyLocators) {
        this.command = command;
        this.bytes = ("$" + command.length() + "\r\n" + command + "\r\n").getBytes(StandardCharsets.ISO_8859_1);
        this.arity = arity;
        this.needGetKeys = needGetKeys;
        this.keyLocators = keyLocators;
        this.readOnly = readOnly;
        this.pubsub = pubsub;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public int getArity() {
        return this.arity;
    }

    public boolean isReadOnly(List<byte[]> args) {
        if (this.keyLocators != null) {
            for (int i = this.keyLocators.length - 1; i >= 0; --i) {
                int offset;
                KeyLocator keyLocator = this.keyLocators[i];
                if (keyLocator.begin == null || keyLocator.find == null || (offset = keyLocator.begin.begin(args, this.arity)) == -1) continue;
                if (keyLocator.ro == null) {
                    return true;
                }
                return keyLocator.ro;
            }
        }
        if (this.readOnly == null) {
            return true;
        }
        return this.readOnly;
    }

    public boolean isPubSub() {
        return this.pubsub;
    }

    public boolean needsGetKeys() {
        return this.needGetKeys;
    }

    public List<byte[]> extractKeys(List<byte[]> args) {
        if (this.keyLocators != null) {
            for (int i = this.keyLocators.length - 1; i >= 0; --i) {
                int offset;
                KeyLocator keyLocator = this.keyLocators[i];
                if (keyLocator.begin == null || keyLocator.find == null || (offset = keyLocator.begin.begin(args, this.arity)) == -1) continue;
                ArrayList<byte[]> collector = new ArrayList<byte[]>();
                keyLocator.find.forEach(args, this.arity, offset, (begin, keyIdx, keyStep) -> collector.add((byte[])args.get(keyIdx)));
                return collector;
            }
        }
        return Collections.emptyList();
    }

    public int iterateKeys(List<byte[]> args, KeyConsumer consumer) {
        if (this.keyLocators != null) {
            for (int i = this.keyLocators.length - 1; i >= 0; --i) {
                int offset;
                KeyLocator keyLocator = this.keyLocators[i];
                if (keyLocator.begin == null || keyLocator.find == null || (offset = keyLocator.begin.begin(args, this.arity)) == -1) continue;
                return keyLocator.find.forEach(args, this.arity, offset, consumer);
            }
        }
        return -1;
    }

    public String toString() {
        return this.command;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommandImpl command1 = (CommandImpl)o;
        return Objects.equals(this.command, command1.command);
    }

    public int hashCode() {
        return Objects.hash(this.command);
    }
}

