/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.json.annotations.JsonGen;
import io.vertx.core.json.JsonObject;
import io.vertx.redis.client.PoolOptionsConverter;
import java.util.Map;
import java.util.UUID;

@DataObject
@JsonGen(publicConverter=false)
public class PoolOptions {
    private String name;
    private int cleanerInterval;
    private int maxSize;
    private int maxWaiting;
    private int recycleTimeout;

    public PoolOptions() {
        this.name = UUID.randomUUID().toString();
        this.cleanerInterval = 30000;
        this.maxSize = 6;
        this.maxWaiting = 24;
        this.recycleTimeout = 180000;
    }

    public PoolOptions(PoolOptions other) {
        this.name = other.name;
        this.cleanerInterval = other.cleanerInterval;
        this.maxSize = other.maxSize;
        this.maxWaiting = other.maxWaiting;
        this.recycleTimeout = other.recycleTimeout;
    }

    public PoolOptions(JsonObject json) {
        this();
        PoolOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public String getName() {
        return this.name;
    }

    public PoolOptions setName(String name) {
        this.name = name;
        return this;
    }

    public int getCleanerInterval() {
        return this.cleanerInterval;
    }

    public PoolOptions setCleanerInterval(int cleanerInterval) {
        this.cleanerInterval = cleanerInterval;
        return this;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public PoolOptions setMaxSize(int maxSize) {
        this.maxSize = maxSize;
        return this;
    }

    public int getMaxWaiting() {
        return this.maxWaiting;
    }

    public PoolOptions setMaxWaiting(int maxWaiting) {
        this.maxWaiting = maxWaiting;
        return this;
    }

    public int getRecycleTimeout() {
        return this.recycleTimeout;
    }

    public PoolOptions setRecycleTimeout(int recycleTimeout) {
        this.recycleTimeout = recycleTimeout;
        return this;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        PoolOptionsConverter.toJson(this, json);
        return json;
    }
}

