/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.impl;

import io.vertx.core.json.JsonObject;
import io.vertx.pgclient.SslMode;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PgConnectionUriParser {
    private static final String SCHEME_DESIGNATOR_REGEX = "postgre(s|sql)://";
    private static final String USER_INFO_REGEX = "((?<userinfo>[a-zA-Z0-9\\-._~%!*]+(:[a-zA-Z0-9\\-._~%!*]+)?)@)?";
    private static final String NET_LOCATION_REGEX = "(?<netloc>[0-9.]+|\\[[a-zA-Z0-9:]+]|[a-zA-Z0-9\\-._~%]+)?";
    private static final String PORT_REGEX = "(:(?<port>\\d+))?";
    private static final String DATABASE_REGEX = "(/(?<database>[a-zA-Z0-9\\-._~%!*]+))?";
    private static final String PARAMS_REGEX = "(\\?(?<params>.*))?";
    private static final Pattern SCHEME_DESIGNATOR_PATTERN = Pattern.compile("^postgre(s|sql)://");
    private static final Pattern FULL_URI_PATTERN = Pattern.compile("^postgre(s|sql)://((?<userinfo>[a-zA-Z0-9\\-._~%!*]+(:[a-zA-Z0-9\\-._~%!*]+)?)@)?(?<netloc>[0-9.]+|\\[[a-zA-Z0-9:]+]|[a-zA-Z0-9\\-._~%]+)?(:(?<port>\\d+))?(/(?<database>[a-zA-Z0-9\\-._~%!*]+))?(\\?(?<params>.*))?$");

    public static JsonObject parse(String connectionUri) {
        return PgConnectionUriParser.parse(connectionUri, true);
    }

    public static JsonObject parse(String connectionUri, boolean exact) {
        try {
            Matcher matcher = SCHEME_DESIGNATOR_PATTERN.matcher(connectionUri);
            if (matcher.find() || exact) {
                JsonObject configuration = new JsonObject();
                PgConnectionUriParser.doParse(connectionUri, configuration);
                return configuration;
            }
            return null;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot parse invalid connection URI: " + connectionUri, e);
        }
    }

    private static void doParse(String connectionUri, JsonObject configuration) {
        Matcher matcher = FULL_URI_PATTERN.matcher(connectionUri);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Wrong syntax of connection URI");
        }
        PgConnectionUriParser.parseUserAndPassword(matcher.group("userinfo"), configuration);
        PgConnectionUriParser.parseNetLocation(matcher.group("netloc"), configuration);
        PgConnectionUriParser.parsePort(matcher.group("port"), configuration);
        PgConnectionUriParser.parseDatabaseName(matcher.group("database"), configuration);
        PgConnectionUriParser.parseParameters(matcher.group("params"), configuration);
    }

    private static void parseUserAndPassword(String userInfo, JsonObject configuration) {
        if (userInfo == null || userInfo.isEmpty()) {
            return;
        }
        if (PgConnectionUriParser.occurExactlyOnce(userInfo, ":")) {
            int index = userInfo.indexOf(":");
            String user = userInfo.substring(0, index);
            if (user.isEmpty()) {
                throw new IllegalArgumentException("Can not only specify the password without a concrete user");
            }
            String password = userInfo.substring(index + 1);
            configuration.put("user", (Object)PgConnectionUriParser.decodeUrl(user));
            configuration.put("password", (Object)PgConnectionUriParser.decodeUrl(password));
        } else if (!userInfo.contains(":")) {
            configuration.put("user", (Object)PgConnectionUriParser.decodeUrl(userInfo));
        } else {
            throw new IllegalArgumentException("Can not use multiple delimiters to delimit user and password");
        }
    }

    private static void parseNetLocation(String hostInfo, JsonObject configuration) {
        if (hostInfo == null || hostInfo.isEmpty()) {
            return;
        }
        PgConnectionUriParser.parseNetLocationValue(PgConnectionUriParser.decodeUrl(hostInfo), configuration);
    }

    private static void parsePort(String portInfo, JsonObject configuration) {
        int port;
        if (portInfo == null || portInfo.isEmpty()) {
            return;
        }
        try {
            port = Integer.parseInt(PgConnectionUriParser.decodeUrl(portInfo));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("The port must be a valid integer");
        }
        if (port > 65535 || port <= 0) {
            throw new IllegalArgumentException("The port can only range in 1-65535");
        }
        configuration.put("port", (Object)port);
    }

    private static void parseDatabaseName(String databaseInfo, JsonObject configuration) {
        if (databaseInfo == null || databaseInfo.isEmpty()) {
            return;
        }
        configuration.put("database", (Object)PgConnectionUriParser.decodeUrl(databaseInfo));
    }

    private static void parseParameters(String parametersInfo, JsonObject configuration) {
        if (parametersInfo == null || parametersInfo.isEmpty()) {
            return;
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        block26: for (String parameterPair : parametersInfo.split("&")) {
            if (parameterPair.isEmpty()) continue;
            int indexOfDelimiter = parameterPair.indexOf("=");
            if (indexOfDelimiter < 0) {
                throw new IllegalArgumentException(String.format("Missing delimiter '=' of parameters \"%s\" in the part \"%s\"", parametersInfo, parameterPair));
            }
            String key = parameterPair.substring(0, indexOfDelimiter).toLowerCase();
            String value = PgConnectionUriParser.decodeUrl(parameterPair.substring(indexOfDelimiter + 1).trim());
            switch (key) {
                case "port": {
                    PgConnectionUriParser.parsePort(value, configuration);
                    continue block26;
                }
                case "host": {
                    PgConnectionUriParser.parseNetLocationValue(value, configuration);
                    continue block26;
                }
                case "hostaddr": {
                    configuration.put("host", (Object)value);
                    continue block26;
                }
                case "user": {
                    configuration.put("user", (Object)value);
                    continue block26;
                }
                case "password": {
                    configuration.put("password", (Object)value);
                    continue block26;
                }
                case "dbname": {
                    configuration.put("database", (Object)value);
                    continue block26;
                }
                case "sslmode": {
                    configuration.put("sslMode", (Object)SslMode.of(value));
                    continue block26;
                }
                case "application_name": {
                    properties.put("application_name", value);
                    continue block26;
                }
                case "fallback_application_name": {
                    properties.put("fallback_application_name", value);
                    continue block26;
                }
                case "search_path": {
                    properties.put("search_path", value);
                    continue block26;
                }
                case "options": {
                    properties.put("options", value);
                    continue block26;
                }
                default: {
                    configuration.put(key, (Object)value);
                }
            }
        }
        if (!properties.isEmpty()) {
            configuration.put("properties", properties);
        }
    }

    private static void parseNetLocationValue(String hostValue, JsonObject configuration) {
        if (PgConnectionUriParser.isRegardedAsIpv6Address(hostValue)) {
            configuration.put("host", (Object)hostValue.substring(1, hostValue.length() - 1));
        } else {
            configuration.put("host", (Object)hostValue);
        }
    }

    private static boolean isRegardedAsIpv6Address(String hostAddress) {
        return hostAddress.startsWith("[") && hostAddress.endsWith("]");
    }

    private static String decodeUrl(String url) {
        try {
            return URLDecoder.decode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("The connection uri contains unknown characters that can not be resolved.");
        }
    }

    private static boolean occurExactlyOnce(String uri, String character) {
        return uri.contains(character) && uri.indexOf(character) == uri.lastIndexOf(character);
    }
}

