/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.httpproxy.impl;

import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.Locale;

public class ParseUtils {
    public static final DateTimeFormatter RFC_850_DATE_TIME = new DateTimeFormatterBuilder().appendPattern("EEEE, dd-MMM-yy HH:mm:ss").parseLenient().appendLiteral(" GMT").toFormatter(Locale.US).withZone(ZoneId.of("UTC"));
    public static final DateTimeFormatter ASC_TIME = new DateTimeFormatterBuilder().appendPattern("EEE MMM d HH:mm:ss yyyy").parseLenient().toFormatter(Locale.US).withZone(ZoneId.of("UTC"));

    public static Instant parseHeaderDate(String value) {
        try {
            return ParseUtils.parseHttpDate(value);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Instant parseWarningHeaderDate(String value) {
        int len;
        int index = value.indexOf(32);
        if (index > 0 && (index = value.indexOf(32, index + 1)) > 0 && (index = value.indexOf(32, index + 1)) > 0 && index + 2 < (len = value.length()) && value.charAt(index + 1) == '\"' && value.charAt(len - 1) == '\"') {
            return ParseUtils.parseHeaderDate(value.substring(index + 2, len - 1));
        }
        return null;
    }

    public static String formatHttpDate(Instant date) {
        return DateTimeFormatter.RFC_1123_DATE_TIME.format(OffsetDateTime.ofInstant(date, ZoneOffset.UTC));
    }

    public static Instant parseHttpDate(String value) throws Exception {
        int pos = value.indexOf(44);
        if (pos == 3) {
            return DateTimeFormatter.RFC_1123_DATE_TIME.parse((CharSequence)value, Instant::from);
        }
        if (pos == -1) {
            return ASC_TIME.parse((CharSequence)value, Instant::from);
        }
        return RFC_850_DATE_TIME.parse((CharSequence)value, Instant::from);
    }
}

