/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.vertx.core.Completable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.ThreadingModel;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.impl.Http1xClientConnection;
import io.vertx.core.http.impl.HttpChannelConnector;
import io.vertx.core.http.impl.HttpClientConnectionInternal;
import io.vertx.core.http.impl.HttpClientImpl;
import io.vertx.core.impl.NoStackTraceTimeoutException;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.internal.pool.ConnectResult;
import io.vertx.core.internal.pool.ConnectionPool;
import io.vertx.core.internal.pool.Lease;
import io.vertx.core.internal.pool.PoolConnection;
import io.vertx.core.internal.pool.PoolConnector;
import io.vertx.core.internal.pool.PoolWaiter;
import io.vertx.core.internal.resource.ManagedResource;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.core.spi.metrics.PoolMetrics;
import java.util.List;
import java.util.function.BiFunction;

class SharedHttpClientConnectionGroup
extends ManagedResource
implements PoolConnector<HttpClientConnectionInternal> {
    private static final BiFunction<PoolWaiter<HttpClientConnectionInternal>, List<PoolConnection<HttpClientConnectionInternal>>, PoolConnection<HttpClientConnectionInternal>> LIFO_SELECTOR = (waiter, connections) -> {
        int size = connections.size();
        PoolConnection selected = null;
        long last = 0L;
        for (int i = 0; i < size; ++i) {
            PoolConnection pooled = (PoolConnection)connections.get(i);
            if (pooled.available() <= 0L) continue;
            HttpClientConnectionInternal conn = (HttpClientConnectionInternal)pooled.get();
            if (selected == null) {
                selected = pooled;
                continue;
            }
            if (conn.lastResponseReceivedTimestamp() <= last) continue;
            selected = pooled;
        }
        return selected;
    };
    private final PoolMetrics poolMetrics;
    private final VertxInternal vertx;
    private final HttpClientImpl client;
    private final ClientMetrics clientMetrics;
    private final HttpChannelConnector connector;
    private final ConnectionPool<HttpClientConnectionInternal> pool;

    public SharedHttpClientConnectionGroup(VertxInternal vertx, HttpClientImpl client, ClientMetrics clientMetrics, PoolMetrics poolMetrics, int queueMaxSize, int http1MaxSize, int http2MaxSize, HttpChannelConnector connector) {
        ConnectionPool<HttpClientConnectionInternal> pool = ConnectionPool.pool(this, new int[]{http1MaxSize, http2MaxSize}, queueMaxSize).connectionSelector(LIFO_SELECTOR).contextProvider(client.contextProvider());
        this.vertx = vertx;
        this.client = client;
        this.poolMetrics = poolMetrics;
        this.clientMetrics = clientMetrics;
        this.connector = connector;
        this.pool = pool;
    }

    @Override
    public Future<ConnectResult<HttpClientConnectionInternal>> connect(ContextInternal context, PoolConnector.Listener listener) {
        return this.connector.httpConnect(context).map(connection -> {
            this.incRefCount();
            connection.evictionHandler(v -> {
                this.decRefCount();
                listener.onRemove();
            });
            connection.concurrencyChangeHandler(listener::onConcurrencyChange);
            long capacity = connection.concurrency();
            Handler<HttpConnection> connectionHandler = this.client.connectionHandler();
            if (connectionHandler != null) {
                context.emit(connection, connectionHandler);
            }
            int idx = connection instanceof Http1xClientConnection ? 0 : 1;
            return new ConnectResult<HttpClientConnectionInternal>((HttpClientConnectionInternal)connection, capacity, idx);
        });
    }

    @Override
    public boolean isValid(HttpClientConnectionInternal connection) {
        return connection.isValid();
    }

    @Override
    protected void checkExpired() {
        this.pool.evict(conn -> !conn.isValid(), (lst, err) -> {
            if (err == null) {
                lst.forEach(HttpConnection::close);
            }
        });
    }

    public Future<Lease<HttpClientConnectionInternal>> requestConnection(ContextInternal ctx, long timeout) {
        Future<Lease<HttpClientConnectionInternal>> fut = this.requestConnection2(ctx, timeout);
        if (this.poolMetrics != null) {
            Object metric = this.poolMetrics.enqueue();
            fut = fut.andThen(ar -> this.poolMetrics.dequeue(metric));
        }
        return fut;
    }

    private Future<Lease<HttpClientConnectionInternal>> requestConnection2(ContextInternal ctx, long timeout) {
        PromiseInternal<Lease<HttpClientConnectionInternal>> promise = ctx.promise();
        ContextInternal connCtx = ctx.toBuilder().withThreadingModel(ThreadingModel.EVENT_LOOP).build();
        Request request = new Request(connCtx, this.client.options().getProtocolVersion(), timeout, promise);
        request.acquire();
        return promise.future();
    }

    @Override
    protected void handleClose() {
        this.pool.close((res, err) -> {});
    }

    @Override
    protected void cleanup() {
        if (this.clientMetrics != null) {
            this.clientMetrics.close();
        }
        if (this.poolMetrics != null) {
            this.poolMetrics.close();
        }
    }

    private class Request
    implements PoolWaiter.Listener<HttpClientConnectionInternal>,
    Completable<Lease<HttpClientConnectionInternal>> {
        private final ContextInternal context;
        private final HttpVersion protocol;
        private final long timeout;
        private final Promise<Lease<HttpClientConnectionInternal>> promise;
        private long timerID;

        Request(ContextInternal context, HttpVersion protocol, long timeout, Promise<Lease<HttpClientConnectionInternal>> promise) {
            this.context = context;
            this.protocol = protocol;
            this.timeout = timeout;
            this.promise = promise;
            this.timerID = -1L;
        }

        @Override
        public void onEnqueue(PoolWaiter<HttpClientConnectionInternal> waiter) {
            this.onConnect(waiter);
        }

        @Override
        public void onConnect(PoolWaiter<HttpClientConnectionInternal> waiter) {
            if (this.timeout > 0L && this.timerID == -1L) {
                this.timerID = this.context.setTimer(this.timeout, id -> SharedHttpClientConnectionGroup.this.pool.cancel(waiter, (res, err) -> {
                    if (err == null & res) {
                        this.promise.fail(new NoStackTraceTimeoutException("The timeout of " + this.timeout + " ms has been exceeded when getting a connection to " + String.valueOf(SharedHttpClientConnectionGroup.this.connector.server())));
                    }
                }));
            }
        }

        @Override
        public void complete(Lease<HttpClientConnectionInternal> result, Throwable failure) {
            if (this.timerID >= 0L) {
                this.context.owner().cancelTimer(this.timerID);
            }
            this.promise.complete(result, failure);
        }

        void acquire() {
            SharedHttpClientConnectionGroup.this.pool.acquire(this.context, this, this.protocol == HttpVersion.HTTP_2 ? 1 : 0, this);
        }
    }
}

