/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http;

import io.vertx.core.http.WebSocketConnectOptions;
import io.vertx.core.http.WebSocketVersion;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.Map;

public class WebSocketConnectOptionsConverter {
    static void fromJson(Iterable<Map.Entry<String, Object>> json, WebSocketConnectOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "version": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setVersion(WebSocketVersion.valueOf((String)member.getValue()));
                    break;
                }
                case "subProtocols": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<String> list = new ArrayList<String>();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((String)item);
                        }
                    });
                    obj.setSubProtocols(list);
                    break;
                }
                case "allowOriginHeader": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setAllowOriginHeader((Boolean)member.getValue());
                    break;
                }
                case "registerWriteHandlers": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setRegisterWriteHandlers((Boolean)member.getValue());
                }
            }
        }
    }

    static void toJson(WebSocketConnectOptions obj, JsonObject json) {
        WebSocketConnectOptionsConverter.toJson(obj, json.getMap());
    }

    static void toJson(WebSocketConnectOptions obj, Map<String, Object> json) {
        if (obj.getVersion() != null) {
            json.put("version", obj.getVersion().name());
        }
        if (obj.getSubProtocols() != null) {
            JsonArray array = new JsonArray();
            obj.getSubProtocols().forEach(item -> array.add(item));
            json.put("subProtocols", array);
        }
        json.put("allowOriginHeader", obj.getAllowOriginHeader());
        json.put("registerWriteHandlers", obj.isRegisterWriteHandlers());
    }
}

