/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpClientUpgradeHandler;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.concurrent.EventExecutor;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.GoAway;
import io.vertx.core.http.Http2Settings;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.StreamPriority;
import io.vertx.core.http.impl.Http1xClientConnection;
import io.vertx.core.http.impl.Http2ClientConnection;
import io.vertx.core.http.impl.HttpClientConnection;
import io.vertx.core.http.impl.HttpClientImpl;
import io.vertx.core.http.impl.HttpClientRequestImpl;
import io.vertx.core.http.impl.HttpClientStream;
import io.vertx.core.http.impl.VertxHttp2ClientUpgradeCodec;
import io.vertx.core.http.impl.VertxHttp2ConnectionHandler;
import io.vertx.core.http.impl.pool.ConnectionListener;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.cert.X509Certificate;

public class Http2UpgradedClientConnection
implements HttpClientConnection {
    private HttpClientImpl client;
    private HttpClientConnection current;
    private Handler<Void> closeHandler;
    private Handler<Void> shutdownHandler;
    private Handler<GoAway> goAwayHandler;
    private Handler<Throwable> exceptionHandler;
    private Handler<Buffer> pingHandler;
    private Handler<Http2Settings> remoteSettingsHandler;

    Http2UpgradedClientConnection(HttpClientImpl client, Http1xClientConnection connection) {
        this.client = client;
        this.current = connection;
    }

    @Override
    public ChannelHandlerContext channelHandlerContext() {
        return this.current.channelHandlerContext();
    }

    @Override
    public Channel channel() {
        return this.current.channel();
    }

    @Override
    public void close() {
        this.current.close();
    }

    @Override
    public Object metric() {
        return this.current.metric();
    }

    @Override
    public void createStream(Handler<AsyncResult<HttpClientStream>> handler) {
        if (this.current instanceof Http1xClientConnection) {
            this.current.createStream(ar -> {
                if (ar.succeeded()) {
                    HttpClientStream stream = (HttpClientStream)ar.result();
                    UpgradingStream upgradingStream = new UpgradingStream(stream, (Http1xClientConnection)this.current);
                    handler.handle(Future.succeededFuture(upgradingStream));
                } else {
                    handler.handle((AsyncResult<HttpClientStream>)ar);
                }
            });
        } else {
            this.current.createStream(handler);
        }
    }

    @Override
    public ContextInternal getContext() {
        return this.current.getContext();
    }

    @Override
    public HttpConnection closeHandler(Handler<Void> handler) {
        this.closeHandler = handler;
        this.current.closeHandler(handler);
        return this;
    }

    @Override
    public HttpConnection exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        this.current.exceptionHandler(handler);
        return this;
    }

    @Override
    public HttpConnection remoteSettingsHandler(Handler<Http2Settings> handler) {
        if (this.current instanceof Http1xClientConnection) {
            this.remoteSettingsHandler = handler;
        } else {
            this.current.remoteSettingsHandler(handler);
        }
        return this;
    }

    @Override
    public HttpConnection pingHandler(@Nullable Handler<Buffer> handler) {
        if (this.current instanceof Http1xClientConnection) {
            this.pingHandler = handler;
        } else {
            this.current.pingHandler(handler);
        }
        return this;
    }

    @Override
    public HttpConnection goAwayHandler(@Nullable Handler<GoAway> handler) {
        if (this.current instanceof Http1xClientConnection) {
            this.goAwayHandler = handler;
        } else {
            this.current.goAwayHandler(handler);
        }
        return this;
    }

    @Override
    public HttpConnection shutdownHandler(@Nullable Handler<Void> handler) {
        if (this.current instanceof Http1xClientConnection) {
            this.shutdownHandler = handler;
        } else {
            this.current.shutdownHandler(handler);
        }
        return this;
    }

    @Override
    public HttpConnection goAway(long errorCode, int lastStreamId, Buffer debugData) {
        return this.current.goAway(errorCode, lastStreamId, debugData);
    }

    @Override
    public HttpConnection shutdown(long timeoutMs) {
        return this.current.shutdown(timeoutMs);
    }

    @Override
    public HttpConnection updateSettings(Http2Settings settings) {
        return this.current.updateSettings(settings);
    }

    @Override
    public HttpConnection updateSettings(Http2Settings settings, Handler<AsyncResult<Void>> completionHandler) {
        return this.current.updateSettings(settings, completionHandler);
    }

    @Override
    public Http2Settings settings() {
        return this.current.settings();
    }

    @Override
    public Http2Settings remoteSettings() {
        return this.current.remoteSettings();
    }

    @Override
    public HttpConnection ping(Buffer data, Handler<AsyncResult<Buffer>> pongHandler) {
        return this.current.ping(data, pongHandler);
    }

    @Override
    public SocketAddress remoteAddress() {
        return this.current.remoteAddress();
    }

    @Override
    public SocketAddress localAddress() {
        return this.current.localAddress();
    }

    @Override
    public boolean isSsl() {
        return this.current.isSsl();
    }

    @Override
    public SSLSession sslSession() {
        return this.current.sslSession();
    }

    @Override
    public X509Certificate[] peerCertificateChain() throws SSLPeerUnverifiedException {
        return this.current.peerCertificateChain();
    }

    @Override
    public String indicatedServerName() {
        return this.current.indicatedServerName();
    }

    @Override
    public boolean isValid() {
        return this.current.isValid();
    }

    private class UpgradingStream
    implements HttpClientStream {
        private HttpClientRequestImpl request;
        private Http1xClientConnection conn;
        private HttpClientStream stream;
        private long pendingSize = 0L;
        private List<Object> pending = new ArrayList<Object>();

        UpgradingStream(HttpClientStream stream, Http1xClientConnection conn) {
            this.conn = conn;
            this.stream = stream;
        }

        @Override
        public HttpClientConnection connection() {
            return Http2UpgradedClientConnection.this;
        }

        @Override
        public void writeHead(HttpMethod method, String rawMethod, String uri, MultiMap headers, String hostHeader, boolean chunked, ByteBuf buf, boolean end, StreamPriority priority, Handler<Void> continueHandler, Handler<AsyncResult<Void>> handler) {
            final ChannelPipeline pipeline = this.conn.channel().pipeline();
            HttpClientCodec httpCodec = (HttpClientCodec)pipeline.get(HttpClientCodec.class);
            VertxHttp2ClientUpgradeCodec upgradeCodec = new VertxHttp2ClientUpgradeCodec(Http2UpgradedClientConnection.this.client.getOptions().getInitialSettings()){

                @Override
                public void upgradeTo(ChannelHandlerContext ctx, FullHttpResponse upgradeResponse) throws Exception {
                    ConnectionListener<HttpClientConnection> listener = UpgradingStream.this.conn.listener();
                    VertxHttp2ConnectionHandler<Http2ClientConnection> handler = Http2ClientConnection.createHttp2ConnectionHandler(Http2UpgradedClientConnection.this.client, UpgradingStream.this.conn.endpointMetric(), listener, UpgradingStream.this.conn.getContext(), Http2UpgradedClientConnection.this.current.metric(), (conn, concurrency) -> conn.upgradeStream(UpgradingStream.this.stream.metric(), ar -> {
                        UpgradingStream.this.conn.closeHandler((Handler)null);
                        UpgradingStream.this.conn.exceptionHandler((Handler)null);
                        if (ar.succeeded()) {
                            HttpClientStream upgradedStream = (HttpClientStream)ar.result();
                            upgradedStream.beginRequest(UpgradingStream.this.request);
                            Http2UpgradedClientConnection.this.current = conn;
                            conn.closeHandler(Http2UpgradedClientConnection.this.closeHandler);
                            conn.exceptionHandler(Http2UpgradedClientConnection.this.exceptionHandler);
                            conn.pingHandler(Http2UpgradedClientConnection.this.pingHandler);
                            conn.goAwayHandler(Http2UpgradedClientConnection.this.goAwayHandler);
                            conn.shutdownHandler(Http2UpgradedClientConnection.this.shutdownHandler);
                            conn.remoteSettingsHandler(Http2UpgradedClientConnection.this.remoteSettingsHandler);
                            listener.onConcurrencyChange((long)concurrency);
                        } else {
                            ar.cause().printStackTrace();
                        }
                    }));
                    UpgradingStream.this.conn.channel().pipeline().addLast(new ChannelHandler[]{handler});
                    handler.clientUpgrade(ctx);
                }
            };
            HttpClientUpgradeHandler upgradeHandler = new HttpClientUpgradeHandler((HttpClientUpgradeHandler.SourceCodec)httpCodec, upgradeCodec, 65536){

                public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                    if (UpgradingStream.this.pending != null) {
                        boolean lower;
                        int maxContent = this.maxContentLength();
                        boolean bl = lower = UpgradingStream.this.pendingSize < (long)maxContent;
                        if (msg instanceof ByteBufHolder) {
                            UpgradingStream.this.pendingSize = UpgradingStream.this.pendingSize + (long)((ByteBufHolder)msg).content().readableBytes();
                        } else if (msg instanceof ByteBuf) {
                            UpgradingStream.this.pendingSize = UpgradingStream.this.pendingSize + (long)((ByteBuf)msg).readableBytes();
                        }
                        if (UpgradingStream.this.pendingSize >= (long)maxContent) {
                            if (lower) {
                                UpgradingStream.this.pending.clear();
                                ctx.fireExceptionCaught((Throwable)new TooLongFrameException("Max content exceeded " + this.maxContentLength() + " bytes."));
                            }
                            return;
                        }
                        UpgradingStream.this.pending.add(msg);
                    } else {
                        super.channelRead(ctx, msg);
                    }
                }
            };
            class UpgradeRequestHandler
            extends ChannelInboundHandlerAdapter {
                UpgradeRequestHandler() {
                }

                public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                    super.userEventTriggered(ctx, evt);
                    ChannelPipeline pipeline2 = ctx.pipeline();
                    if (evt == HttpClientUpgradeHandler.UpgradeEvent.UPGRADE_SUCCESSFUL) {
                        pipeline2.remove((ChannelHandler)UpgradingStream.this.conn.handler());
                    }
                }

                public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                    if (msg instanceof HttpResponse) {
                        pipeline.remove((ChannelHandler)this);
                        HttpResponse resp = (HttpResponse)msg;
                        if (resp.status() != HttpResponseStatus.SWITCHING_PROTOCOLS) {
                            resp.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
                        }
                    }
                    super.channelRead(ctx, msg);
                }
            }
            pipeline.addAfter("codec", null, (ChannelHandler)new UpgradeRequestHandler());
            pipeline.addAfter("codec", null, (ChannelHandler)upgradeHandler);
            this.doWriteHead(method, rawMethod, uri, headers, hostHeader, chunked, buf, end, priority, continueHandler, handler);
        }

        private void doWriteHead(HttpMethod method, String rawMethod, String uri, MultiMap headers, String hostHeader, boolean chunked, ByteBuf buf, boolean end, StreamPriority priority, Handler<Void> continueHandler, Handler<AsyncResult<Void>> handler) {
            EventExecutor exec = this.conn.channelHandlerContext().executor();
            if (exec.inEventLoop()) {
                this.stream.writeHead(method, rawMethod, uri, headers, hostHeader, chunked, buf, end, priority, continueHandler, handler);
                if (end) {
                    this.end();
                }
            } else {
                exec.execute(() -> this.doWriteHead(method, rawMethod, uri, headers, hostHeader, chunked, buf, end, priority, continueHandler, handler));
            }
        }

        private void end() {
            List<Object> messages = this.pending;
            this.pending = null;
            ChannelHandlerContext context = this.conn.channelHandlerContext().pipeline().context("codec");
            for (Object msg : messages) {
                context.fireChannelRead(msg);
            }
        }

        @Override
        public int id() {
            return 1;
        }

        @Override
        public Object metric() {
            return this.stream.metric();
        }

        @Override
        public HttpVersion version() {
            return HttpVersion.HTTP_2;
        }

        @Override
        public Context getContext() {
            return this.stream.getContext();
        }

        @Override
        public void writeBuffer(ByteBuf buf, boolean end, Handler<AsyncResult<Void>> handler) {
            EventExecutor exec = this.conn.channelHandlerContext().executor();
            if (exec.inEventLoop()) {
                this.stream.writeBuffer(buf, end, handler);
                if (end) {
                    this.end();
                }
            } else {
                exec.execute(() -> this.writeBuffer(buf, end, handler));
            }
        }

        @Override
        public void writeFrame(int type, int flags, ByteBuf payload) {
            this.stream.writeFrame(type, flags, payload);
        }

        @Override
        public void doSetWriteQueueMaxSize(int size) {
            this.stream.doSetWriteQueueMaxSize(size);
        }

        @Override
        public boolean isNotWritable() {
            return this.stream.isNotWritable();
        }

        @Override
        public void doPause() {
            this.stream.doPause();
        }

        @Override
        public void doFetch(long amount) {
            this.stream.doFetch(amount);
        }

        @Override
        public void reset(Throwable cause) {
            this.stream.reset(cause);
        }

        @Override
        public void beginRequest(HttpClientRequestImpl req) {
            this.request = req;
            this.stream.beginRequest(req);
        }

        @Override
        public void endRequest() {
            this.stream.endRequest();
        }

        @Override
        public NetSocket createNetSocket() {
            return this.stream.createNetSocket();
        }

        @Override
        public StreamPriority priority() {
            return this.stream.priority();
        }

        @Override
        public void updatePriority(StreamPriority streamPriority) {
            this.stream.updatePriority(streamPriority);
        }
    }
}

