/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.vertx.core.Handler;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.impl.HttpClientImpl;
import io.vertx.core.http.impl.HttpClientRequestImpl;
import io.vertx.core.http.impl.HttpClientResponseImpl;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.net.SocketAddress;
import java.util.concurrent.TimeoutException;

public abstract class HttpClientRequestBase
implements HttpClientRequest {
    private static final Logger log = LoggerFactory.getLogger(HttpClientRequestImpl.class);
    protected final HttpClientImpl client;
    protected final HttpMethod method;
    protected final String uri;
    protected final String path;
    protected final String query;
    protected final String host;
    protected final int port;
    protected final SocketAddress server;
    protected final boolean ssl;
    private Handler<Throwable> exceptionHandler;
    private long currentTimeoutTimerId = -1L;
    private long currentTimeoutMs;
    private long lastDataReceived;
    protected Throwable exceptionOccurred;
    private Object metric;
    private boolean paused;
    private HttpClientResponseImpl response;

    HttpClientRequestBase(HttpClientImpl client, boolean ssl, HttpMethod method, SocketAddress server, String host, int port, String uri) {
        this.client = client;
        this.uri = uri;
        this.method = method;
        this.server = server;
        this.host = host;
        this.port = port;
        this.path = uri.length() > 0 ? HttpUtils.parsePath(uri) : "";
        this.query = HttpUtils.parseQuery(uri);
        this.ssl = ssl;
    }

    Object metric() {
        return this.metric;
    }

    void metric(Object metric) {
        this.metric = metric;
    }

    protected abstract void doHandleResponse(HttpClientResponseImpl var1, long var2);

    protected abstract void checkComplete();

    protected String hostHeader() {
        if (this.port == 80 && !this.ssl || this.port == 443 && this.ssl) {
            return this.host;
        }
        return this.host + ':' + this.port;
    }

    @Override
    public String absoluteURI() {
        return (this.ssl ? "https://" : "http://") + this.hostHeader() + this.uri;
    }

    @Override
    public String query() {
        return this.query;
    }

    @Override
    public String path() {
        return this.path;
    }

    @Override
    public String uri() {
        return this.uri;
    }

    public String host() {
        return this.server.host();
    }

    @Override
    public HttpMethod method() {
        return this.method;
    }

    @Override
    public synchronized HttpClientRequest exceptionHandler(Handler<Throwable> handler) {
        if (handler != null) {
            this.checkComplete();
            this.exceptionHandler = handler;
        } else {
            this.exceptionHandler = null;
        }
        return this;
    }

    synchronized Handler<Throwable> exceptionHandler() {
        return this.exceptionHandler;
    }

    @Override
    public synchronized HttpClientRequest setTimeout(long timeoutMs) {
        this.cancelOutstandingTimeoutTimer();
        this.currentTimeoutMs = timeoutMs;
        this.currentTimeoutTimerId = this.client.getVertx().setTimer(timeoutMs, id -> this.handleTimeout(timeoutMs));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleException(Throwable t) {
        Handler<Throwable> handler;
        HttpClientRequestBase httpClientRequestBase = this;
        synchronized (httpClientRequestBase) {
            this.cancelOutstandingTimeoutTimer();
            this.exceptionOccurred = t;
            handler = this.exceptionHandler != null ? this.exceptionHandler : log::error;
        }
        handler.handle(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleResponse(HttpClientResponseImpl resp) {
        HttpClientRequestBase httpClientRequestBase = this;
        synchronized (httpClientRequestBase) {
            this.response = resp;
        }
        this.checkHandleResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkHandleResponse() {
        HttpClientResponseImpl resp;
        HttpClientRequestBase httpClientRequestBase = this;
        synchronized (httpClientRequestBase) {
            if (this.response != null) {
                if (this.paused) {
                    return;
                }
            } else {
                return;
            }
            resp = this.response;
            this.response = null;
        }
        this.doHandleResponse(resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void doHandleResponse(HttpClientResponseImpl resp) {
        long timeoutMS;
        HttpClientRequestBase httpClientRequestBase = this;
        synchronized (httpClientRequestBase) {
            if (this.exceptionOccurred != null) {
                return;
            }
            timeoutMS = this.cancelOutstandingTimeoutTimer();
        }
        try {
            this.doHandleResponse(resp, timeoutMS);
        }
        catch (Throwable t) {
            this.handleException(t);
        }
    }

    private long cancelOutstandingTimeoutTimer() {
        long ret = this.currentTimeoutTimerId;
        if (ret != -1L) {
            this.client.getVertx().cancelTimer(this.currentTimeoutTimerId);
            this.currentTimeoutTimerId = -1L;
            ret = this.currentTimeoutMs;
            this.currentTimeoutMs = 0L;
        }
        return ret;
    }

    private void handleTimeout(long timeoutMs) {
        if (this.lastDataReceived == 0L) {
            this.timeout(timeoutMs);
        } else {
            long now = System.currentTimeMillis();
            long timeSinceLastData = now - this.lastDataReceived;
            if (timeSinceLastData >= timeoutMs) {
                this.timeout(timeoutMs);
            } else {
                this.lastDataReceived = 0L;
                this.setTimeout(timeoutMs - timeSinceLastData);
            }
        }
    }

    private void timeout(long timeoutMs) {
        String msg = "The timeout period of " + timeoutMs + "ms has been exceeded while executing " + (Object)((Object)this.method) + " " + this.uri + " for server " + this.server;
        this.handleException(new TimeoutException(msg){

            @Override
            public synchronized Throwable fillInStackTrace() {
                return this;
            }
        });
        this.reset(0L);
    }

    synchronized void dataReceived() {
        if (this.currentTimeoutTimerId != -1L) {
            this.lastDataReceived = System.currentTimeMillis();
        }
    }

    @Override
    public HttpClientRequest pause() {
        this.paused = true;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientRequest resume() {
        HttpClientRequestBase httpClientRequestBase = this;
        synchronized (httpClientRequestBase) {
            if (!this.paused) {
                return this;
            }
            this.paused = false;
        }
        this.checkHandleResponse();
        return this;
    }

    @Override
    public synchronized HttpClientRequest fetch(long amount) {
        if (amount < 0L) {
            throw new IllegalArgumentException();
        }
        if (amount > 0L) {
            this.resume();
        }
        return this;
    }
}

