/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.file.AsyncFile;
import io.vertx.core.file.OpenOptions;
import io.vertx.core.http.HttpServerFileUpload;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.streams.Pump;
import io.vertx.core.streams.WriteStream;
import io.vertx.core.streams.impl.InboundBuffer;
import java.nio.charset.Charset;

class HttpServerFileUploadImpl
implements HttpServerFileUpload {
    private final HttpServerRequest req;
    private final Context context;
    private final String name;
    private final String filename;
    private final String contentType;
    private final String contentTransferEncoding;
    private final Charset charset;
    private Handler<Void> endHandler;
    private AsyncFile file;
    private Handler<Throwable> exceptionHandler;
    private long size;
    private InboundBuffer<Buffer> pending;
    private boolean complete;
    private boolean lazyCalculateSize;

    HttpServerFileUploadImpl(Context context, HttpServerRequest req, String name, String filename, String contentType, String contentTransferEncoding, Charset charset, long size) {
        this.context = context;
        this.req = req;
        this.name = name;
        this.filename = filename;
        this.contentType = contentType;
        this.contentTransferEncoding = contentTransferEncoding;
        this.charset = charset;
        this.size = size;
        this.pending = new InboundBuffer(context).drainHandler(v -> req.resume()).emptyHandler(v -> {
            if (this.complete) {
                this.handleComplete();
            }
        });
        if (size == 0L) {
            this.lazyCalculateSize = true;
        }
    }

    @Override
    public String filename() {
        return this.filename;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String contentType() {
        return this.contentType;
    }

    @Override
    public String contentTransferEncoding() {
        return this.contentTransferEncoding;
    }

    @Override
    public String charset() {
        return this.charset.toString();
    }

    @Override
    public synchronized long size() {
        return this.size;
    }

    @Override
    public HttpServerFileUpload handler(Handler<Buffer> handler) {
        this.pending.handler(handler);
        return this;
    }

    @Override
    public HttpServerFileUpload pause() {
        this.pending.pause();
        return this;
    }

    @Override
    public HttpServerFileUpload fetch(long amount) {
        this.pending.resume();
        return this;
    }

    @Override
    public HttpServerFileUpload resume() {
        this.pending.resume();
        return this;
    }

    @Override
    public synchronized HttpServerFileUpload exceptionHandler(Handler<Throwable> exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
        return this;
    }

    @Override
    public synchronized HttpServerFileUpload endHandler(Handler<Void> handler) {
        this.endHandler = handler;
        return this;
    }

    @Override
    public HttpServerFileUpload streamToFileSystem(String filename) {
        this.pause();
        this.context.owner().fileSystem().open(filename, new OpenOptions(), ar -> {
            if (ar.succeeded()) {
                this.file = (AsyncFile)ar.result();
                Pump p = Pump.pump(this, (WriteStream)ar.result());
                p.start();
                this.resume();
            } else {
                this.notifyExceptionHandler(ar.cause());
            }
        });
        return this;
    }

    @Override
    public synchronized boolean isSizeAvailable() {
        return !this.lazyCalculateSize;
    }

    synchronized void receiveData(Buffer data) {
        if (data.length() != 0) {
            if (this.lazyCalculateSize) {
                this.size += (long)data.length();
            }
            this.doReceiveData(data);
        }
    }

    synchronized void doReceiveData(Buffer data) {
        if (!this.pending.write(data)) {
            this.req.pause();
        }
    }

    synchronized void complete() {
        if (this.pending.isEmpty()) {
            this.handleComplete();
        } else {
            this.complete = true;
        }
    }

    private void handleComplete() {
        this.lazyCalculateSize = false;
        if (this.file == null) {
            this.notifyEndHandler();
        } else {
            this.file.close(ar -> {
                if (ar.failed()) {
                    this.notifyExceptionHandler(ar.cause());
                }
                this.notifyEndHandler();
            });
        }
    }

    private void notifyEndHandler() {
        if (this.endHandler != null) {
            this.endHandler.handle(null);
        }
    }

    private void notifyExceptionHandler(Throwable cause) {
        if (this.exceptionHandler != null) {
            this.exceptionHandler.handle(cause);
        }
    }
}

