/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.ssl.SniHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.net.impl.SSLHelper;
import javax.net.ssl.SSLEngine;

public class VertxSniHandler
extends SniHandler {
    public static AttributeKey<String> SERVER_NAME_ATTR = AttributeKey.valueOf((String)"sniServerName");
    private final SSLHelper helper;
    private ChannelHandlerContext context;
    private final Promise<Channel> handshakeFuture;

    public VertxSniHandler(SSLHelper helper, VertxInternal vertx) {
        super(input -> helper.getContext(vertx, (String)input));
        this.helper = helper;
        this.handshakeFuture = new DefaultPromise<Channel>(){

            protected EventExecutor executor() {
                ChannelHandlerContext ctx = VertxSniHandler.this.context;
                if (ctx == null) {
                    throw new IllegalStateException();
                }
                return ctx.executor();
            }
        };
    }

    public Future<Channel> handshakeFuture() {
        return this.handshakeFuture;
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.context = ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void replaceHandler(ChannelHandlerContext ctx, String hostname, SslContext sslContext) throws Exception {
        SslHandler sslHandler = null;
        try {
            SSLEngine engine = this.helper.createEngine(sslContext);
            sslHandler = new SslHandler(engine);
            ctx.pipeline().replace((ChannelHandler)this, "ssl", (ChannelHandler)sslHandler);
            Future fut = sslHandler.handshakeFuture();
            fut.addListener(future -> {
                if (future.isSuccess()) {
                    Attribute val = ctx.channel().attr(SERVER_NAME_ATTR);
                    val.set((Object)hostname);
                    this.handshakeFuture.setSuccess((Object)ctx.channel());
                } else {
                    this.handshakeFuture.setFailure(future.cause());
                }
            });
            sslHandler = null;
        }
        finally {
            if (sslHandler != null) {
                ReferenceCountUtil.safeRelease((Object)sslHandler.engine());
            }
        }
    }
}

