/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.buffer.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.CharsetUtil;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.Arguments;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public class BufferImpl
implements Buffer {
    private ByteBuf buffer;

    BufferImpl() {
        this(0);
    }

    BufferImpl(int initialSizeHint) {
        this.buffer = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.buffer((int)initialSizeHint, (int)Integer.MAX_VALUE));
    }

    BufferImpl(byte[] bytes) {
        this.buffer = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.buffer((int)bytes.length, (int)Integer.MAX_VALUE)).writeBytes(bytes);
    }

    BufferImpl(String str, String enc) {
        this(str.getBytes(Charset.forName(Objects.requireNonNull(enc))));
    }

    BufferImpl(String str, Charset cs) {
        this(str.getBytes(cs));
    }

    BufferImpl(String str) {
        this(str, StandardCharsets.UTF_8);
    }

    BufferImpl(ByteBuf buffer) {
        this.buffer = Unpooled.unreleasableBuffer((ByteBuf)buffer);
    }

    @Override
    public String toString() {
        return this.buffer.toString(StandardCharsets.UTF_8);
    }

    @Override
    public String toString(String enc) {
        return this.buffer.toString(Charset.forName(enc));
    }

    @Override
    public String toString(Charset enc) {
        return this.buffer.toString(enc);
    }

    @Override
    public JsonObject toJsonObject() {
        return new JsonObject(this);
    }

    @Override
    public JsonArray toJsonArray() {
        return new JsonArray(this);
    }

    @Override
    public byte getByte(int pos) {
        return this.buffer.getByte(pos);
    }

    @Override
    public short getUnsignedByte(int pos) {
        return this.buffer.getUnsignedByte(pos);
    }

    @Override
    public int getInt(int pos) {
        return this.buffer.getInt(pos);
    }

    @Override
    public int getIntLE(int pos) {
        return this.buffer.getIntLE(pos);
    }

    @Override
    public long getUnsignedInt(int pos) {
        return this.buffer.getUnsignedInt(pos);
    }

    @Override
    public long getUnsignedIntLE(int pos) {
        return this.buffer.getUnsignedIntLE(pos);
    }

    @Override
    public long getLong(int pos) {
        return this.buffer.getLong(pos);
    }

    @Override
    public long getLongLE(int pos) {
        return this.buffer.getLongLE(pos);
    }

    @Override
    public double getDouble(int pos) {
        return this.buffer.getDouble(pos);
    }

    @Override
    public float getFloat(int pos) {
        return this.buffer.getFloat(pos);
    }

    @Override
    public short getShort(int pos) {
        return this.buffer.getShort(pos);
    }

    @Override
    public short getShortLE(int pos) {
        return this.buffer.getShortLE(pos);
    }

    @Override
    public int getUnsignedShort(int pos) {
        return this.buffer.getUnsignedShort(pos);
    }

    @Override
    public int getUnsignedShortLE(int pos) {
        return this.buffer.getUnsignedShortLE(pos);
    }

    @Override
    public int getMedium(int pos) {
        return this.buffer.getMedium(pos);
    }

    @Override
    public int getMediumLE(int pos) {
        return this.buffer.getMediumLE(pos);
    }

    @Override
    public int getUnsignedMedium(int pos) {
        return this.buffer.getUnsignedMedium(pos);
    }

    @Override
    public int getUnsignedMediumLE(int pos) {
        return this.buffer.getUnsignedMediumLE(pos);
    }

    @Override
    public byte[] getBytes() {
        byte[] arr = new byte[this.buffer.writerIndex()];
        this.buffer.getBytes(0, arr);
        return arr;
    }

    @Override
    public byte[] getBytes(int start, int end) {
        Arguments.require(end >= start, "end must be greater or equal than start");
        byte[] arr = new byte[end - start];
        this.buffer.getBytes(start, arr, 0, end - start);
        return arr;
    }

    @Override
    public Buffer getBytes(byte[] dst) {
        return this.getBytes(dst, 0);
    }

    @Override
    public Buffer getBytes(byte[] dst, int dstIndex) {
        return this.getBytes(0, this.buffer.writerIndex(), dst, dstIndex);
    }

    @Override
    public Buffer getBytes(int start, int end, byte[] dst) {
        return this.getBytes(start, end, dst, 0);
    }

    @Override
    public Buffer getBytes(int start, int end, byte[] dst, int dstIndex) {
        Arguments.require(end >= start, "end must be greater or equal than start");
        this.buffer.getBytes(start, dst, dstIndex, end - start);
        return this;
    }

    @Override
    public Buffer getBuffer(int start, int end) {
        return new BufferImpl(this.getBytes(start, end));
    }

    @Override
    public String getString(int start, int end, String enc) {
        byte[] bytes = this.getBytes(start, end);
        Charset cs = Charset.forName(enc);
        return new String(bytes, cs);
    }

    @Override
    public String getString(int start, int end) {
        byte[] bytes = this.getBytes(start, end);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    @Override
    public Buffer appendBuffer(Buffer buff) {
        this.buffer.writeBytes(buff.getByteBuf());
        return this;
    }

    @Override
    public Buffer appendBuffer(Buffer buff, int offset, int len) {
        ByteBuf byteBuf = buff.getByteBuf();
        int from = byteBuf.readerIndex() + offset;
        this.buffer.writeBytes(byteBuf, from, len);
        return this;
    }

    @Override
    public Buffer appendBytes(byte[] bytes) {
        this.buffer.writeBytes(bytes);
        return this;
    }

    @Override
    public Buffer appendBytes(byte[] bytes, int offset, int len) {
        this.buffer.writeBytes(bytes, offset, len);
        return this;
    }

    @Override
    public Buffer appendByte(byte b) {
        this.buffer.writeByte((int)b);
        return this;
    }

    @Override
    public Buffer appendUnsignedByte(short b) {
        this.buffer.writeByte((int)b);
        return this;
    }

    @Override
    public Buffer appendInt(int i) {
        this.buffer.writeInt(i);
        return this;
    }

    @Override
    public Buffer appendIntLE(int i) {
        this.buffer.writeIntLE(i);
        return this;
    }

    @Override
    public Buffer appendUnsignedInt(long i) {
        this.buffer.writeInt((int)i);
        return this;
    }

    @Override
    public Buffer appendUnsignedIntLE(long i) {
        this.buffer.writeIntLE((int)i);
        return this;
    }

    @Override
    public Buffer appendMedium(int i) {
        this.buffer.writeMedium(i);
        return this;
    }

    @Override
    public Buffer appendMediumLE(int i) {
        this.buffer.writeMediumLE(i);
        return this;
    }

    @Override
    public Buffer appendLong(long l) {
        this.buffer.writeLong(l);
        return this;
    }

    @Override
    public Buffer appendLongLE(long l) {
        this.buffer.writeLongLE(l);
        return this;
    }

    @Override
    public Buffer appendShort(short s) {
        this.buffer.writeShort((int)s);
        return this;
    }

    @Override
    public Buffer appendShortLE(short s) {
        this.buffer.writeShortLE((int)s);
        return this;
    }

    @Override
    public Buffer appendUnsignedShort(int s) {
        this.buffer.writeShort(s);
        return this;
    }

    @Override
    public Buffer appendUnsignedShortLE(int s) {
        this.buffer.writeShortLE(s);
        return this;
    }

    @Override
    public Buffer appendFloat(float f) {
        this.buffer.writeFloat(f);
        return this;
    }

    @Override
    public Buffer appendDouble(double d) {
        this.buffer.writeDouble(d);
        return this;
    }

    @Override
    public Buffer appendString(String str, String enc) {
        return this.append(str, Charset.forName(Objects.requireNonNull(enc)));
    }

    @Override
    public Buffer appendString(String str) {
        return this.append(str, CharsetUtil.UTF_8);
    }

    @Override
    public Buffer setByte(int pos, byte b) {
        this.ensureWritable(pos, 1);
        this.buffer.setByte(pos, (int)b);
        return this;
    }

    @Override
    public Buffer setUnsignedByte(int pos, short b) {
        this.ensureWritable(pos, 1);
        this.buffer.setByte(pos, (int)b);
        return this;
    }

    @Override
    public Buffer setInt(int pos, int i) {
        this.ensureWritable(pos, 4);
        this.buffer.setInt(pos, i);
        return this;
    }

    @Override
    public Buffer setIntLE(int pos, int i) {
        this.ensureWritable(pos, 4);
        this.buffer.setIntLE(pos, i);
        return this;
    }

    @Override
    public Buffer setUnsignedInt(int pos, long i) {
        this.ensureWritable(pos, 4);
        this.buffer.setInt(pos, (int)i);
        return this;
    }

    @Override
    public Buffer setUnsignedIntLE(int pos, long i) {
        this.ensureWritable(pos, 4);
        this.buffer.setIntLE(pos, (int)i);
        return this;
    }

    @Override
    public Buffer setMedium(int pos, int i) {
        this.ensureWritable(pos, 3);
        this.buffer.setMedium(pos, i);
        return this;
    }

    @Override
    public Buffer setMediumLE(int pos, int i) {
        this.ensureWritable(pos, 3);
        this.buffer.setMediumLE(pos, i);
        return this;
    }

    @Override
    public Buffer setLong(int pos, long l) {
        this.ensureWritable(pos, 8);
        this.buffer.setLong(pos, l);
        return this;
    }

    @Override
    public Buffer setLongLE(int pos, long l) {
        this.ensureWritable(pos, 8);
        this.buffer.setLongLE(pos, l);
        return this;
    }

    @Override
    public Buffer setDouble(int pos, double d) {
        this.ensureWritable(pos, 8);
        this.buffer.setDouble(pos, d);
        return this;
    }

    @Override
    public Buffer setFloat(int pos, float f) {
        this.ensureWritable(pos, 4);
        this.buffer.setFloat(pos, f);
        return this;
    }

    @Override
    public Buffer setShort(int pos, short s) {
        this.ensureWritable(pos, 2);
        this.buffer.setShort(pos, (int)s);
        return this;
    }

    @Override
    public Buffer setShortLE(int pos, short s) {
        this.ensureWritable(pos, 2);
        this.buffer.setShortLE(pos, (int)s);
        return this;
    }

    @Override
    public Buffer setUnsignedShort(int pos, int s) {
        this.ensureWritable(pos, 2);
        this.buffer.setShort(pos, s);
        return this;
    }

    @Override
    public Buffer setUnsignedShortLE(int pos, int s) {
        this.ensureWritable(pos, 2);
        this.buffer.setShortLE(pos, s);
        return this;
    }

    @Override
    public Buffer setBuffer(int pos, Buffer b) {
        this.ensureWritable(pos, b.length());
        this.buffer.setBytes(pos, b.getByteBuf());
        return this;
    }

    @Override
    public Buffer setBuffer(int pos, Buffer b, int offset, int len) {
        this.ensureWritable(pos, len);
        ByteBuf byteBuf = b.getByteBuf();
        this.buffer.setBytes(pos, byteBuf, byteBuf.readerIndex() + offset, len);
        return this;
    }

    @Override
    public BufferImpl setBytes(int pos, ByteBuffer b) {
        this.ensureWritable(pos, b.limit());
        this.buffer.setBytes(pos, b);
        return this;
    }

    @Override
    public Buffer setBytes(int pos, byte[] b) {
        this.ensureWritable(pos, b.length);
        this.buffer.setBytes(pos, b);
        return this;
    }

    @Override
    public Buffer setBytes(int pos, byte[] b, int offset, int len) {
        this.ensureWritable(pos, len);
        this.buffer.setBytes(pos, b, offset, len);
        return this;
    }

    @Override
    public Buffer setString(int pos, String str) {
        return this.setBytes(pos, str, CharsetUtil.UTF_8);
    }

    @Override
    public Buffer setString(int pos, String str, String enc) {
        return this.setBytes(pos, str, Charset.forName(enc));
    }

    @Override
    public int length() {
        return this.buffer.writerIndex();
    }

    @Override
    public Buffer copy() {
        return new BufferImpl(this.buffer.copy());
    }

    @Override
    public Buffer slice() {
        return new BufferImpl(this.buffer.slice());
    }

    @Override
    public Buffer slice(int start, int end) {
        return new BufferImpl(this.buffer.slice(start, end - start));
    }

    @Override
    public ByteBuf getByteBuf() {
        return this.buffer.duplicate();
    }

    private Buffer append(String str, Charset charset) {
        byte[] bytes = str.getBytes(charset);
        this.buffer.writeBytes(bytes);
        return this;
    }

    private Buffer setBytes(int pos, String str, Charset charset) {
        byte[] bytes = str.getBytes(charset);
        this.ensureWritable(pos, bytes.length);
        this.buffer.setBytes(pos, bytes);
        return this;
    }

    private void ensureWritable(int pos, int len) {
        int ni = pos + len;
        int cap = this.buffer.capacity();
        int over = ni - cap;
        if (over > 0) {
            this.buffer.writerIndex(cap);
            this.buffer.ensureWritable(over);
        }
        if (ni > this.buffer.writerIndex()) {
            this.buffer.writerIndex(ni);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BufferImpl buffer1 = (BufferImpl)o;
        return this.buffer != null ? this.buffer.equals((Object)buffer1.buffer) : buffer1.buffer == null;
    }

    public int hashCode() {
        return this.buffer != null ? this.buffer.hashCode() : 0;
    }

    @Override
    public void writeToBuffer(Buffer buff) {
        buff.appendInt(this.length());
        buff.appendBuffer(this);
    }

    @Override
    public int readFromBuffer(int pos, Buffer buffer) {
        int len = buffer.getInt(pos);
        Buffer b = buffer.getBuffer(pos + 4, pos + 4 + len);
        this.buffer = b.getByteBuf();
        return pos + 4 + len;
    }
}

