/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.webauthn.impl.attestation;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.impl.CertificateHelper;
import io.vertx.ext.auth.impl.Codec;
import io.vertx.ext.auth.impl.jose.JWS;
import io.vertx.ext.auth.impl.jose.JWT;
import io.vertx.ext.auth.webauthn.AttestationCertificates;
import io.vertx.ext.auth.webauthn.PublicKeyCredential;
import io.vertx.ext.auth.webauthn.WebAuthnOptions;
import io.vertx.ext.auth.webauthn.impl.AuthData;
import io.vertx.ext.auth.webauthn.impl.attestation.Attestation;
import io.vertx.ext.auth.webauthn.impl.attestation.AttestationException;
import io.vertx.ext.auth.webauthn.impl.metadata.MetaData;
import io.vertx.ext.auth.webauthn.impl.metadata.MetaDataException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;

public class AndroidSafetynetAttestation
implements Attestation {
    @Override
    public String fmt() {
        return "android-safetynet";
    }

    @Override
    public AttestationCertificates validate(WebAuthnOptions options, MetaData metadata, byte[] clientDataJSON, JsonObject attestation, AuthData authData) throws AttestationException {
        try {
            long now;
            JsonObject attStmt = attestation.getJsonObject("attStmt");
            if (!attStmt.containsKey("ver") || attStmt.getString("ver") == null || attStmt.getString("ver").length() == 0) {
                throw new AttestationException("Missing {ver} in attStmt");
            }
            JsonObject token = JWT.parse((byte[])Codec.base64UrlDecode((String)attStmt.getString("response")));
            byte[] clientDataHash = Attestation.hash("SHA-256", clientDataJSON);
            Buffer nonceBase = Buffer.buffer().appendBytes(authData.getRaw()).appendBytes(clientDataHash);
            if (!MessageDigest.isEqual(Attestation.hash("SHA-256", nonceBase.getBytes()), Codec.base64Decode((String)token.getJsonObject("payload").getString("nonce")))) {
                throw new AttestationException("JWS nonce does not contains expected nonce!");
            }
            if (!token.getJsonObject("payload").getBoolean("ctsProfileMatch").booleanValue()) {
                throw new AttestationException("JWS ctsProfileMatch is false!");
            }
            long timestampMs = token.getJsonObject("payload").getLong("timestampMs", Long.valueOf(0L));
            if (timestampMs > (now = System.currentTimeMillis()) || timestampMs + options.getTimeoutInMilliseconds() < now) {
                throw new AttestationException("timestampMs is invalid!");
            }
            JsonArray x5c = token.getJsonObject("header").getJsonArray("x5c");
            if (x5c == null || x5c.size() == 0) {
                throw new AttestationException("Invalid certificate chain");
            }
            ArrayList<X509Certificate> certChain = new ArrayList<X509Certificate>();
            for (int i = 0; i < x5c.size(); ++i) {
                byte[] bytes = Codec.base64Decode((String)x5c.getString(i));
                certChain.add(JWS.parseX5c((byte[])bytes));
                x5c.set(i, (Object)bytes);
            }
            if (!"attest.android.com".equals(CertificateHelper.getCertInfo((X509Certificate)((X509Certificate)certChain.get(0))).subject("CN"))) {
                throw new AttestationException("The common name is not set to 'attest.android.com'!");
            }
            JsonObject statement = metadata.verifyMetadata(authData.getAaguidString(), PublicKeyCredential.valueOf(token.getJsonObject("header").getString("alg")), certChain, options.getRootCertificate(this.fmt()));
            if (statement != null && !MetaData.statementAttestationTypesContains(statement, 15884)) {
                throw new AttestationException("Metadata does not indicate support for anonca attestations");
            }
            Attestation.verifySignature(PublicKeyCredential.valueOf(token.getJsonObject("header").getString("alg")), (X509Certificate)certChain.get(0), Codec.base64UrlDecode((String)token.getString("signature")), token.getString("signatureBase").getBytes(StandardCharsets.UTF_8));
            return new AttestationCertificates().setAlg(PublicKeyCredential.valueOf(token.getJsonObject("header").getString("alg"))).setX5c(x5c);
        }
        catch (MetaDataException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | CertificateException e) {
            throw new AttestationException(e);
        }
    }
}

