/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.webauthn;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.codegen.json.annotations.JsonGen;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.impl.Codec;
import io.vertx.ext.auth.webauthn.AttestationCertificates;
import io.vertx.ext.auth.webauthn.AuthenticatorConverter;
import java.util.Map;
import java.util.UUID;

@DataObject
@JsonGen(publicConverter=false)
public class Authenticator {
    private String userName;
    private String type = "public-key";
    private String credID;
    private String publicKey;
    private long counter;
    private String aaguid;
    private AttestationCertificates attestationCertificates;
    private String fmt;
    private int flags;

    public Authenticator() {
    }

    public Authenticator(JsonObject json) {
        AuthenticatorConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public String getUserName() {
        return this.userName;
    }

    public Authenticator setUserName(String userName) {
        this.userName = userName;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public Authenticator setType(String type) {
        this.type = type;
        return this;
    }

    public String getCredID() {
        return this.credID;
    }

    public Authenticator setCredID(String credID) {
        this.credID = credID;
        return this;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public Authenticator setPublicKey(String publicKey) {
        this.publicKey = publicKey;
        return this;
    }

    public long getCounter() {
        return this.counter;
    }

    public Authenticator setCounter(long counter) {
        this.counter = counter;
        return this;
    }

    public Authenticator setAttestationCertificates(AttestationCertificates attestationCertificates) {
        this.attestationCertificates = attestationCertificates;
        return this;
    }

    public AttestationCertificates getAttestationCertificates() {
        return this.attestationCertificates;
    }

    public int getFlags() {
        return this.flags;
    }

    public Authenticator setFlags(int flags) {
        this.flags = flags;
        return this;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        AuthenticatorConverter.toJson(this, json);
        return json;
    }

    public static @Nullable UUID toUUID(String string) {
        if (string == null) {
            return null;
        }
        Buffer buffer = Buffer.buffer((byte[])Codec.base64UrlDecode((String)string));
        return new UUID(buffer.getLong(0), buffer.getLong(8));
    }

    public String toString() {
        return this.toJson().encode();
    }

    public Authenticator setFmt(String fmt) {
        this.fmt = fmt;
        return this;
    }

    public String getFmt() {
        return this.fmt;
    }

    public Authenticator setAaguid(String aaguid) {
        this.aaguid = aaguid;
        return this;
    }

    public String getAaguid() {
        return this.aaguid;
    }
}

