/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.oauth2;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.json.annotations.JsonGen;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.oauth2.OAuth2AuthorizationURLConverter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@DataObject
@JsonGen(publicConverter=false)
public class OAuth2AuthorizationURL {
    private String redirectUri;
    private List<String> scopes;
    private String state;
    private Map<String, String> additionalParameters;

    public OAuth2AuthorizationURL() {
    }

    public OAuth2AuthorizationURL(JsonObject json) {
        OAuth2AuthorizationURLConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public OAuth2AuthorizationURL setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
        return this;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public OAuth2AuthorizationURL setScopes(List<String> scopes) {
        this.scopes = scopes;
        return this;
    }

    public OAuth2AuthorizationURL addScope(String scope) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<String>();
        }
        this.scopes.add(scope);
        return this;
    }

    public String getState() {
        return this.state;
    }

    public OAuth2AuthorizationURL setState(String state) {
        this.state = state;
        return this;
    }

    public Map<String, String> getAdditionalParameters() {
        return this.additionalParameters;
    }

    public OAuth2AuthorizationURL setAdditionalParameters(Map<String, String> additionalParameters) {
        this.additionalParameters = additionalParameters;
        return this;
    }

    public OAuth2AuthorizationURL putAdditionalParameter(String key, String value) {
        if (this.additionalParameters == null) {
            this.additionalParameters = new HashMap<String, String>();
        }
        this.additionalParameters.put(key, value);
        return this;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        OAuth2AuthorizationURLConverter.toJson(this, json);
        return json;
    }

    public String toString() {
        return this.toJson().encode();
    }
}

