/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.predicate;

import io.undertow.attribute.ExchangeAttribute;
import io.undertow.attribute.ExchangeAttributes;
import io.undertow.predicate.Predicate;
import io.undertow.predicate.PredicateBuilder;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.servlet.handlers.ServletRequestContext;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class DirectoryPredicate
implements Predicate {
    private final ExchangeAttribute location;

    public DirectoryPredicate(ExchangeAttribute location) {
        this.location = location;
    }

    public boolean resolve(HttpServerExchange value) {
        String location = this.location.readAttribute(value);
        ServletRequestContext src = (ServletRequestContext)value.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        if (src == null) {
            return false;
        }
        ResourceManager manager = src.getDeployment().getDeploymentInfo().getResourceManager();
        if (manager == null) {
            return false;
        }
        try {
            Resource resource = manager.getResource(location);
            if (resource == null) {
                return false;
            }
            return resource.isDirectory();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static class Builder
    implements PredicateBuilder {
        public String name() {
            return "directory";
        }

        public Map<String, Class<?>> parameters() {
            HashMap params = new HashMap();
            params.put("value", ExchangeAttribute.class);
            return params;
        }

        public Set<String> requiredParameters() {
            return Collections.emptySet();
        }

        public String defaultParameter() {
            return "value";
        }

        public Predicate build(Map<String, Object> config) {
            ExchangeAttribute value = (ExchangeAttribute)config.get("value");
            if (value == null) {
                value = ExchangeAttributes.relativePath();
            }
            return new DirectoryPredicate(value);
        }
    }
}

