/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.attribute;

import io.undertow.attribute.ExchangeAttribute;
import io.undertow.attribute.ExchangeAttributeBuilder;
import io.undertow.attribute.ReadOnlyAttributeException;
import io.undertow.security.api.SecurityContext;
import io.undertow.server.HttpServerExchange;

public class RemoteUserAttribute
implements ExchangeAttribute {
    public static final String REMOTE_USER_SHORT = "%u";
    public static final String REMOTE_USER = "%{REMOTE_USER}";
    public static final ExchangeAttribute INSTANCE = new RemoteUserAttribute();

    private RemoteUserAttribute() {
    }

    @Override
    public String readAttribute(HttpServerExchange exchange) {
        SecurityContext sc = exchange.getSecurityContext();
        if (sc == null || !sc.isAuthenticated()) {
            return null;
        }
        return sc.getAuthenticatedAccount().getPrincipal().getName();
    }

    @Override
    public void writeAttribute(HttpServerExchange exchange, String newValue) throws ReadOnlyAttributeException {
        throw new ReadOnlyAttributeException("Remote user", newValue);
    }

    public String toString() {
        return REMOTE_USER;
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "Remote user";
        }

        @Override
        public ExchangeAttribute build(String token) {
            if (token.equals(RemoteUserAttribute.REMOTE_USER) || token.equals(RemoteUserAttribute.REMOTE_USER_SHORT)) {
                return INSTANCE;
            }
            return null;
        }

        @Override
        public int priority() {
            return 0;
        }
    }
}

