/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.HttpUpgradeListener;
import io.undertow.server.handlers.HttpUpgradeHandshake;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.util.CopyOnWriteMap;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import java.nio.channels.Channel;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.StreamConnection;

public final class ChannelUpgradeHandler
implements HttpHandler {
    private final CopyOnWriteMap<String, List<Holder>> handlers = new CopyOnWriteMap();
    private volatile HttpHandler nonUpgradeHandler = ResponseCodeHandler.HANDLE_404;

    public synchronized void addProtocol(String productString, ChannelListener<? super StreamConnection> openListener, HttpUpgradeHandshake handshake) {
        this.addProtocol(productString, null, openListener, handshake);
    }

    public synchronized void addProtocol(String productString, HttpUpgradeListener openListener, HttpUpgradeHandshake handshake) {
        this.addProtocol(productString, openListener, null, handshake);
    }

    private synchronized void addProtocol(String productString, HttpUpgradeListener openListener, final ChannelListener<? super StreamConnection> channelListener, HttpUpgradeHandshake handshake) {
        List<Holder> list;
        if (productString == null) {
            throw new IllegalArgumentException("productString is null");
        }
        if (openListener == null && channelListener == null) {
            throw new IllegalArgumentException("openListener is null");
        }
        if (openListener == null) {
            openListener = new HttpUpgradeListener(){

                @Override
                public void handleUpgrade(StreamConnection streamConnection, HttpServerExchange exchange) {
                    ChannelListeners.invokeChannelListener((Channel)streamConnection, (ChannelListener)channelListener);
                }
            };
        }
        if ((list = this.handlers.get(productString)) == null) {
            list = new CopyOnWriteArrayList<Holder>();
            this.handlers.put(productString, list);
        }
        list.add(new Holder(openListener, handshake, channelListener));
    }

    public void addProtocol(String productString, ChannelListener<? super StreamConnection> openListener) {
        this.addProtocol(productString, openListener, null);
    }

    public void addProtocol(String productString, HttpUpgradeListener openListener) {
        this.addProtocol(productString, openListener, null);
    }

    public synchronized void removeProtocol(String productString) {
        this.handlers.remove(productString);
    }

    public synchronized void removeProtocol(String productString, ChannelListener<? super StreamConnection> openListener) {
        List<Holder> holders = this.handlers.get(productString);
        if (holders == null) {
            return;
        }
        Iterator<Holder> it = holders.iterator();
        while (it.hasNext()) {
            Holder holder = it.next();
            if (holder.channelListener != openListener) continue;
            it.remove();
            break;
        }
        if (holders.isEmpty()) {
            this.handlers.remove(productString);
        }
    }

    public synchronized void removeProtocol(String productString, HttpUpgradeListener upgradeListener) {
        List<Holder> holders = this.handlers.get(productString);
        if (holders == null) {
            return;
        }
        Iterator<Holder> it = holders.iterator();
        while (it.hasNext()) {
            Holder holder = it.next();
            if (holder.listener != upgradeListener) continue;
            it.remove();
            break;
        }
        if (holders.isEmpty()) {
            this.handlers.remove(productString);
        }
    }

    public HttpHandler getNonUpgradeHandler() {
        return this.nonUpgradeHandler;
    }

    public ChannelUpgradeHandler setNonUpgradeHandler(HttpHandler nonUpgradeHandler) {
        Handlers.handlerNotNull(nonUpgradeHandler);
        this.nonUpgradeHandler = nonUpgradeHandler;
        return this;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        HeaderValues upgradeStrings = exchange.getRequestHeaders().get(Headers.UPGRADE);
        if (upgradeStrings != null && exchange.getRequestMethod().equals(Methods.GET)) {
            for (String string : upgradeStrings) {
                List<Holder> holders = this.handlers.get(string);
                if (holders == null) continue;
                for (Holder holder : holders) {
                    HttpUpgradeListener listener = holder.listener;
                    if (holder.handshake != null && !holder.handshake.handleUpgrade(exchange)) continue;
                    exchange.upgradeChannel(string, listener);
                    exchange.endExchange();
                    return;
                }
            }
        }
        this.nonUpgradeHandler.handleRequest(exchange);
    }

    private static final class Holder {
        final HttpUpgradeListener listener;
        final HttpUpgradeHandshake handshake;
        final ChannelListener<? super StreamConnection> channelListener;

        private Holder(HttpUpgradeListener listener, HttpUpgradeHandshake handshake, ChannelListener<? super StreamConnection> channelListener) {
            this.listener = listener;
            this.handshake = handshake;
            this.channelListener = channelListener;
        }
    }
}

