/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.protocols.alpn;

import io.undertow.UndertowLogger;
import io.undertow.protocols.alpn.ALPNProvider;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.net.ssl.SSLEngine;

public class OpenSSLAlpnProvider
implements ALPNProvider {
    public static final OpenSSLALPNMethods OPENSSL_ALPN_METHODS = AccessController.doPrivileged(new PrivilegedAction<OpenSSLALPNMethods>(){

        @Override
        public OpenSSLALPNMethods run() {
            try {
                Class<?> openSSLEngine = Class.forName(OpenSSLAlpnProvider.OPENSSL_ENGINE, true, OpenSSLAlpnProvider.class.getClassLoader());
                Method setApplicationProtocols = openSSLEngine.getMethod("setApplicationProtocols", String[].class);
                Method getApplicationProtocol = openSSLEngine.getMethod("getSelectedApplicationProtocol", new Class[0]);
                UndertowLogger.ROOT_LOGGER.debug("OpenSSL ALPN Enabled");
                return new OpenSSLALPNMethods(setApplicationProtocols, getApplicationProtocol);
            }
            catch (Throwable e) {
                UndertowLogger.ROOT_LOGGER.debug("OpenSSL ALPN disabled", e);
                return null;
            }
        }
    });
    public static final String OPENSSL_ENGINE = "org.wildfly.openssl.OpenSSLEngine";

    @Override
    public boolean isEnabled(SSLEngine sslEngine) {
        return OPENSSL_ALPN_METHODS != null && sslEngine.getClass().getName().equals(OPENSSL_ENGINE);
    }

    @Override
    public SSLEngine setProtocols(SSLEngine engine, String[] protocols) {
        try {
            OPENSSL_ALPN_METHODS.setApplicationProtocols().invoke((Object)engine, new Object[]{protocols});
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        return engine;
    }

    @Override
    public String getSelectedProtocol(SSLEngine engine) {
        try {
            return (String)OPENSSL_ALPN_METHODS.getApplicationProtocol().invoke((Object)engine, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getPriority() {
        return 400;
    }

    public static class OpenSSLALPNMethods {
        private final Method setApplicationProtocols;
        private final Method getApplicationProtocol;

        OpenSSLALPNMethods(Method setApplicationProtocols, Method getApplicationProtocol) {
            this.setApplicationProtocols = setApplicationProtocols;
            this.getApplicationProtocol = getApplicationProtocol;
        }

        public Method getApplicationProtocol() {
            return this.getApplicationProtocol;
        }

        public Method setApplicationProtocols() {
            return this.setApplicationProtocols;
        }
    }
}

