/*
 * Decompiled with CFR 0.152.
 */
package io.tus.java.client;

import io.tus.java.client.ProtocolException;
import io.tus.java.client.TusClient;
import io.tus.java.client.TusInputStream;
import io.tus.java.client.TusUpload;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;

public class TusUploader {
    private URL uploadURL;
    private Proxy proxy;
    private TusInputStream input;
    private long offset;
    private TusClient client;
    private TusUpload upload;
    private byte[] buffer;
    private int requestPayloadSize = 0xA00000;
    private int bytesRemainingForRequest;
    private HttpURLConnection connection;
    private OutputStream output;

    public TusUploader(TusClient client, TusUpload upload, URL uploadURL, TusInputStream input, long offset) throws IOException {
        this.uploadURL = uploadURL;
        this.input = input;
        this.offset = offset;
        this.client = client;
        this.upload = upload;
        input.seekTo(offset);
        this.setChunkSize(0x200000);
    }

    private void openConnection() throws IOException, ProtocolException {
        if (this.connection != null) {
            return;
        }
        this.bytesRemainingForRequest = this.requestPayloadSize;
        this.input.mark(this.requestPayloadSize);
        this.connection = this.proxy != null ? (HttpURLConnection)this.uploadURL.openConnection(this.proxy) : (HttpURLConnection)this.uploadURL.openConnection();
        this.client.prepareConnection(this.connection);
        this.connection.setRequestProperty("Upload-Offset", Long.toString(this.offset));
        this.connection.setRequestProperty("Content-Type", "application/offset+octet-stream");
        this.connection.setRequestProperty("Expect", "100-continue");
        try {
            this.connection.setRequestMethod("PATCH");
        }
        catch (java.net.ProtocolException pe) {
            this.connection.setRequestMethod("POST");
            this.connection.setRequestProperty("X-HTTP-Method-Override", "PATCH");
        }
        this.connection.setDoOutput(true);
        this.connection.setChunkedStreamingMode(0);
        try {
            this.output = this.connection.getOutputStream();
        }
        catch (java.net.ProtocolException pe) {
            if (this.connection.getResponseCode() != -1) {
                this.finish();
            }
            throw pe;
        }
    }

    public void setChunkSize(int size) {
        this.buffer = new byte[size];
    }

    public int getChunkSize() {
        return this.buffer.length;
    }

    public void setRequestPayloadSize(int size) throws IllegalStateException {
        if (this.connection != null) {
            throw new IllegalStateException("payload size for a single request must not be modified as long as a request is in progress");
        }
        this.requestPayloadSize = size;
    }

    public int getRequestPayloadSize() {
        return this.requestPayloadSize;
    }

    public int uploadChunk() throws IOException, ProtocolException {
        this.openConnection();
        int bytesToRead = Math.min(this.getChunkSize(), this.bytesRemainingForRequest);
        int bytesRead = this.input.read(this.buffer, bytesToRead);
        if (bytesRead == -1) {
            return -1;
        }
        this.output.write(this.buffer, 0, bytesRead);
        this.output.flush();
        this.offset += (long)bytesRead;
        this.bytesRemainingForRequest -= bytesRead;
        if (this.bytesRemainingForRequest <= 0) {
            this.finishConnection();
        }
        return bytesRead;
    }

    @Deprecated
    public int uploadChunk(int chunkSize) throws IOException, ProtocolException {
        this.openConnection();
        byte[] buf = new byte[chunkSize];
        int bytesRead = this.input.read(buf, chunkSize);
        if (bytesRead == -1) {
            return -1;
        }
        this.output.write(buf, 0, bytesRead);
        this.output.flush();
        this.offset += (long)bytesRead;
        return bytesRead;
    }

    public long getOffset() {
        return this.offset;
    }

    public URL getUploadURL() {
        return this.uploadURL;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void finish() throws ProtocolException, IOException {
        this.finish(true);
    }

    public void finish(boolean closeInputStream) throws ProtocolException, IOException {
        this.finishConnection();
        if (this.upload.getSize() == this.offset) {
            this.client.uploadFinished(this.upload);
        }
        if (closeInputStream) {
            this.input.close();
        }
    }

    private void finishConnection() throws ProtocolException, IOException {
        if (this.output != null) {
            this.output.close();
        }
        if (this.connection != null) {
            int responseCode = this.connection.getResponseCode();
            this.connection.disconnect();
            if (responseCode < 200 || responseCode >= 300) {
                throw new ProtocolException("unexpected status code (" + responseCode + ") while uploading chunk", this.connection);
            }
            long serverOffset = this.getHeaderFieldLong(this.connection, "Upload-Offset");
            if (serverOffset == -1L) {
                throw new ProtocolException("response to PATCH request contains no or invalid Upload-Offset header", this.connection);
            }
            if (this.offset != serverOffset) {
                throw new ProtocolException(String.format("response contains different Upload-Offset value (%d) than expected (%d)", serverOffset, this.offset), this.connection);
            }
            this.connection = null;
        }
    }

    private long getHeaderFieldLong(URLConnection connection, String field) {
        String value = connection.getHeaderField(field);
        if (value == null) {
            return -1L;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }
}

