/*
 * Decompiled with CFR 0.152.
 */
package io.tus.java.client;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

class TusInputStream {
    private InputStream stream;
    private long bytesRead;
    private long lastMark = -1L;

    TusInputStream(InputStream stream) {
        if (!stream.markSupported()) {
            stream = new BufferedInputStream(stream);
        }
        this.stream = stream;
    }

    public int read(byte[] buffer, int length) throws IOException {
        int bytesReadNow = this.stream.read(buffer, 0, length);
        this.bytesRead += (long)bytesReadNow;
        return bytesReadNow;
    }

    public void seekTo(long position) throws IOException {
        if (this.lastMark != -1L) {
            this.stream.reset();
            this.stream.skip(position - this.lastMark);
            this.lastMark = -1L;
        } else {
            this.stream.skip(position);
        }
        this.bytesRead = position;
    }

    public void mark(int readLimit) {
        this.lastMark = this.bytesRead;
        this.stream.mark(readLimit);
    }

    public void close() throws IOException {
        this.stream.close();
    }
}

