/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.testing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ObjectArrays;
import com.google.protobuf.ByteString;
import com.google.protobuf.Empty;
import com.google.protobuf.Timestamp;
import com.uber.m3.tally.NoopScope;
import com.uber.m3.tally.Scope;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.temporal.api.common.v1.Payload;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.api.enums.v1.IndexedValueType;
import io.temporal.api.nexus.v1.Endpoint;
import io.temporal.api.nexus.v1.EndpointSpec;
import io.temporal.api.nexus.v1.EndpointTarget;
import io.temporal.api.operatorservice.v1.AddSearchAttributesRequest;
import io.temporal.api.operatorservice.v1.CreateNexusEndpointRequest;
import io.temporal.api.operatorservice.v1.DeleteNexusEndpointRequest;
import io.temporal.api.operatorservice.v1.OperatorServiceGrpc;
import io.temporal.api.testservice.v1.SleepRequest;
import io.temporal.api.testservice.v1.TestServiceGrpc;
import io.temporal.client.WorkflowClient;
import io.temporal.client.WorkflowClientOptions;
import io.temporal.common.WorkflowExecutionHistory;
import io.temporal.common.interceptors.WorkflowClientInterceptor;
import io.temporal.internal.common.ProtobufTimeUtils;
import io.temporal.internal.testservice.TestWorkflowService;
import io.temporal.serviceclient.OperatorServiceStubs;
import io.temporal.serviceclient.OperatorServiceStubsOptions;
import io.temporal.serviceclient.ServiceStubsOptions;
import io.temporal.serviceclient.TestServiceStubs;
import io.temporal.serviceclient.TestServiceStubsOptions;
import io.temporal.serviceclient.WorkflowServiceStubs;
import io.temporal.serviceclient.WorkflowServiceStubsOptions;
import io.temporal.testing.IdempotentTimeLocker;
import io.temporal.testing.TestEnvironmentOptions;
import io.temporal.testing.TestWorkflowEnvironment;
import io.temporal.testing.TimeLockingInterceptor;
import io.temporal.testserver.TestServer;
import io.temporal.worker.Worker;
import io.temporal.worker.WorkerFactory;
import io.temporal.worker.WorkerFactoryOptions;
import io.temporal.worker.WorkerOptions;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class TestWorkflowEnvironmentInternal
implements TestWorkflowEnvironment {
    private final WorkflowClientOptions workflowClientOptions;
    private final WorkflowServiceStubs workflowServiceStubs;
    private final OperatorServiceStubs operatorServiceStubs;
    @Nullable
    private final TestServiceStubs testServiceStubs;
    @Nullable
    private final TestServer.InProcessTestServer inProcessServer;
    @Nullable
    private final TestWorkflowService service;
    private final WorkerFactory workerFactory;
    @Nullable
    private final TimeLockingInterceptor timeLockingInterceptor;
    private final IdempotentTimeLocker constructorTimeLock;

    public TestWorkflowEnvironmentInternal(@Nullable TestEnvironmentOptions testEnvironmentOptions) {
        if (testEnvironmentOptions == null) {
            testEnvironmentOptions = TestEnvironmentOptions.getDefaultInstance();
        }
        this.workflowClientOptions = WorkflowClientOptions.newBuilder((WorkflowClientOptions)testEnvironmentOptions.getWorkflowClientOptions()).validateAndBuildWithDefaults();
        WorkflowServiceStubsOptions.Builder stubsOptionsBuilder = testEnvironmentOptions.getWorkflowServiceStubsOptions() != null ? WorkflowServiceStubsOptions.newBuilder((ServiceStubsOptions)testEnvironmentOptions.getWorkflowServiceStubsOptions()) : WorkflowServiceStubsOptions.newBuilder();
        Scope metricsScope = testEnvironmentOptions.getMetricsScope();
        if (metricsScope != null && !NoopScope.class.equals(metricsScope.getClass())) {
            stubsOptionsBuilder = (WorkflowServiceStubsOptions.Builder)stubsOptionsBuilder.setMetricsScope(metricsScope);
        }
        if (testEnvironmentOptions.isUseExternalService()) {
            this.inProcessServer = null;
            this.service = null;
            this.workflowServiceStubs = WorkflowServiceStubs.newServiceStubs((WorkflowServiceStubsOptions)((WorkflowServiceStubsOptions.Builder)stubsOptionsBuilder.setTarget(testEnvironmentOptions.getTarget())).build());
            this.testServiceStubs = null;
            this.timeLockingInterceptor = null;
            this.constructorTimeLock = null;
        } else {
            this.inProcessServer = TestServer.createServer((boolean)true, (long)testEnvironmentOptions.getInitialTimeMillis());
            this.service = this.fetchWorkflowService();
            WorkflowServiceStubsOptions workflowServiceStubsOptions = ((WorkflowServiceStubsOptions.Builder)((WorkflowServiceStubsOptions.Builder)stubsOptionsBuilder.setChannel(this.inProcessServer.getChannel())).setTarget(null)).validateAndBuildWithDefaults();
            this.workflowServiceStubs = WorkflowServiceStubs.newServiceStubs((WorkflowServiceStubsOptions)workflowServiceStubsOptions);
            this.testServiceStubs = TestServiceStubs.newServiceStubs((TestServiceStubsOptions)((TestServiceStubsOptions.Builder)TestServiceStubsOptions.newBuilder((ServiceStubsOptions)workflowServiceStubsOptions).setRpcTimeout(Duration.ofMillis(Long.MAX_VALUE))).validateAndBuildWithDefaults());
            this.timeLockingInterceptor = new TimeLockingInterceptor(this.testServiceStubs);
            if (!testEnvironmentOptions.isUseTimeskipping()) {
                this.constructorTimeLock = new IdempotentTimeLocker(this.testServiceStubs);
                this.constructorTimeLock.lockTimeSkipping();
            } else {
                this.constructorTimeLock = null;
            }
        }
        this.operatorServiceStubs = OperatorServiceStubs.newServiceStubs((OperatorServiceStubsOptions)((OperatorServiceStubsOptions.Builder)OperatorServiceStubsOptions.newBuilder().setChannel(this.workflowServiceStubs.getRawChannel())).validateAndBuildWithDefaults());
        WorkflowClient client = WorkflowClient.newInstance((WorkflowServiceStubs)this.workflowServiceStubs, (WorkflowClientOptions)this.workflowClientOptions);
        this.workerFactory = WorkerFactory.newInstance((WorkflowClient)client, (WorkerFactoryOptions)testEnvironmentOptions.getWorkerFactoryOptions());
        testEnvironmentOptions.getSearchAttributes().forEach(this::registerSearchAttribute);
    }

    private TestWorkflowService fetchWorkflowService() {
        return this.inProcessServer.getWorkflowService();
    }

    @Override
    public Worker newWorker(String taskQueue) {
        return this.workerFactory.newWorker(taskQueue, WorkerOptions.getDefaultInstance());
    }

    @Override
    public Worker newWorker(String taskQueue, WorkerOptions options) {
        return this.workerFactory.newWorker(taskQueue, options);
    }

    @Override
    public WorkflowClient getWorkflowClient() {
        WorkflowClientOptions options = this.timeLockingInterceptor != null ? WorkflowClientOptions.newBuilder((WorkflowClientOptions)this.workflowClientOptions).setInterceptors((WorkflowClientInterceptor[])ObjectArrays.concat((Object[])this.workflowClientOptions.getInterceptors(), (Object)((Object)this.timeLockingInterceptor))).build() : this.workflowClientOptions;
        return WorkflowClient.newInstance((WorkflowServiceStubs)this.workflowServiceStubs, (WorkflowClientOptions)options);
    }

    @Override
    public long currentTimeMillis() {
        if (this.testServiceStubs != null) {
            return ProtobufTimeUtils.toJavaInstant((Timestamp)((TestServiceGrpc.TestServiceBlockingStub)this.testServiceStubs.blockingStub()).getCurrentTime(Empty.newBuilder().build()).getTime()).toEpochMilli();
        }
        return System.currentTimeMillis();
    }

    @Override
    public void sleep(Duration duration) {
        if (this.testServiceStubs != null) {
            ((TestServiceGrpc.TestServiceBlockingStub)this.testServiceStubs.blockingStub()).unlockTimeSkippingWithSleep(SleepRequest.newBuilder().setDuration(ProtobufTimeUtils.toProtoDuration((Duration)duration)).build());
        } else {
            try {
                Thread.sleep(duration.toMillis());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void registerDelayedCallback(Duration delay, Runnable r) {
        Preconditions.checkState((this.service != null ? 1 : 0) != 0, (Object)"registerDelayedCallback is not supported with the external service");
        this.service.registerDelayedCallback(delay, r);
    }

    @Override
    public boolean registerSearchAttribute(String name, IndexedValueType type) {
        if (IndexedValueType.INDEXED_VALUE_TYPE_UNSPECIFIED.equals((Object)type)) {
            throw new IllegalArgumentException("Class " + type + " can't be used as a search attribute type");
        }
        AddSearchAttributesRequest request = AddSearchAttributesRequest.newBuilder().setNamespace(this.getNamespace()).putSearchAttributes(name, type).build();
        try {
            ((OperatorServiceGrpc.OperatorServiceBlockingStub)this.operatorServiceStubs.blockingStub()).addSearchAttributes(request);
            return true;
        }
        catch (StatusRuntimeException e) {
            if (Status.Code.ALREADY_EXISTS.equals((Object)e.getStatus().getCode())) {
                return false;
            }
            throw e;
        }
    }

    @Override
    public Endpoint createNexusEndpoint(String name, String taskQueue) {
        EndpointSpec spec = EndpointSpec.newBuilder().setName(name).setDescription(Payload.newBuilder().setData(ByteString.copyFromUtf8((String)"Test Nexus endpoint created by the Java SDK WorkflowTestEnvironment"))).setTarget(EndpointTarget.newBuilder().setWorker(EndpointTarget.Worker.newBuilder().setNamespace(this.getNamespace()).setTaskQueue(taskQueue))).build();
        CreateNexusEndpointRequest request = CreateNexusEndpointRequest.newBuilder().setSpec(spec).build();
        return ((OperatorServiceGrpc.OperatorServiceBlockingStub)this.operatorServiceStubs.blockingStub()).createNexusEndpoint(request).getEndpoint();
    }

    @Override
    public void deleteNexusEndpoint(Endpoint endpoint) {
        ((OperatorServiceGrpc.OperatorServiceBlockingStub)this.operatorServiceStubs.blockingStub()).deleteNexusEndpoint(DeleteNexusEndpointRequest.newBuilder().setId(endpoint.getId()).setVersion(endpoint.getVersion()).build());
    }

    @Override
    @Deprecated
    public WorkflowServiceStubs getWorkflowService() {
        return this.getWorkflowServiceStubs();
    }

    @Override
    public WorkflowServiceStubs getWorkflowServiceStubs() {
        return this.workflowServiceStubs;
    }

    @Override
    public OperatorServiceStubs getOperatorServiceStubs() {
        return this.operatorServiceStubs;
    }

    @Override
    public String getNamespace() {
        return this.workflowClientOptions.getNamespace();
    }

    @Override
    public String getDiagnostics() {
        Preconditions.checkState((this.service != null ? 1 : 0) != 0, (Object)"getDiagnostics is not supported with the external service");
        StringBuilder result = new StringBuilder();
        this.service.getDiagnostics(result);
        return result.toString();
    }

    @Override
    @Deprecated
    public WorkflowExecutionHistory getWorkflowExecutionHistory(@Nonnull WorkflowExecution execution) {
        Preconditions.checkNotNull((Object)execution, (Object)"execution is required");
        return this.getWorkflowClient().fetchHistory(execution.getWorkflowId(), execution.getRunId());
    }

    @Override
    public void close() {
        if (this.testServiceStubs != null) {
            this.testServiceStubs.shutdownNow();
        }
        this.operatorServiceStubs.shutdownNow();
        this.workerFactory.shutdownNow();
        this.workerFactory.awaitTermination(10L, TimeUnit.SECONDS);
        if (this.constructorTimeLock != null) {
            this.constructorTimeLock.unlockTimeSkipping();
        }
        this.workflowServiceStubs.shutdownNow();
        if (this.testServiceStubs != null) {
            this.testServiceStubs.awaitTermination(1L, TimeUnit.SECONDS);
        }
        this.operatorServiceStubs.awaitTermination(1L, TimeUnit.SECONDS);
        this.workflowServiceStubs.awaitTermination(1L, TimeUnit.SECONDS);
        if (this.inProcessServer != null) {
            this.inProcessServer.close();
        }
    }

    @Override
    public void start() {
        this.workerFactory.start();
    }

    @Override
    public boolean isStarted() {
        return this.workerFactory.isStarted();
    }

    @Override
    public boolean isShutdown() {
        return this.workerFactory.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.workerFactory.isTerminated();
    }

    @Override
    @Deprecated
    public void shutdownTestService() {
        if (this.service != null) {
            this.service.close();
        }
    }

    @Override
    public void shutdown() {
        this.workerFactory.shutdown();
    }

    @Override
    public void shutdownNow() {
        this.workerFactory.shutdownNow();
    }

    @Override
    public void awaitTermination(long timeout, TimeUnit unit) {
        this.workerFactory.awaitTermination(timeout, unit);
    }

    @Override
    public WorkerFactory getWorkerFactory() {
        return this.workerFactory;
    }
}

