/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.testing.internal;

import io.temporal.activity.ActivityOptions;
import io.temporal.activity.LocalActivityOptions;
import io.temporal.client.WorkflowOptions;
import java.time.Duration;

public class SDKTestOptions {
    private static final boolean DEBUGGER_TIMEOUTS = false;

    public static WorkflowOptions newWorkflowOptionsForTaskQueue200sTimeout(String taskQueue) {
        return WorkflowOptions.newBuilder().setWorkflowRunTimeout(Duration.ofSeconds(200L)).setWorkflowTaskTimeout(Duration.ofSeconds(60L)).setTaskQueue(taskQueue).build();
    }

    public static WorkflowOptions newWorkflowOptionsWithTimeouts(String taskQueue) {
        return WorkflowOptions.newBuilder().setWorkflowRunTimeout(Duration.ofSeconds(200L)).setWorkflowTaskTimeout(Duration.ofSeconds(5L)).setTaskQueue(taskQueue).build();
    }

    public static ActivityOptions newActivityOptions20sScheduleToClose() {
        return ActivityOptions.newBuilder().setScheduleToCloseTimeout(Duration.ofSeconds(20L)).build();
    }

    public static LocalActivityOptions newLocalActivityOptions20sScheduleToClose() {
        return LocalActivityOptions.newBuilder().setScheduleToCloseTimeout(Duration.ofSeconds(20L)).build();
    }

    public static ActivityOptions newActivityOptionsForTaskQueue(String taskQueue) {
        return ActivityOptions.newBuilder().setTaskQueue(taskQueue).setScheduleToCloseTimeout(Duration.ofSeconds(5L)).setHeartbeatTimeout(Duration.ofSeconds(5L)).setScheduleToStartTimeout(Duration.ofSeconds(5L)).setStartToCloseTimeout(Duration.ofSeconds(5L)).build();
    }

    public static LocalActivityOptions newLocalActivityOptions() {
        return LocalActivityOptions.newBuilder().setScheduleToCloseTimeout(Duration.ofSeconds(5L)).build();
    }
}

